/****** Object:  Table [dbo].[inspect_audit_event_journal]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_audit_event_journal]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_audit_event_journal](
	[MAEJ_EVENT_ID] [int] IDENTITY(300000,1) NOT NULL,
	[MAEJ_INSPECTION_ID] [int] NULL,
	[MAEJ_FII_RECORD_ID] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[MAEJ_EVENT_DATE] [date] NULL,
	[MAEJ_EVENT_TIME] [time](7) NULL,
	[MAEJ_EVENT_USER] [varchar](20) NULL,
	[MAEJ_EVENT_CODE] [varchar](3) NULL,
 CONSTRAINT [PK_AUD_MAEJ] PRIMARY KEY CLUSTERED 
(
	[MAEJ_EVENT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_audit_header]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_audit_header]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_audit_header](
	[MAH_AUDIT_ID] [int] IDENTITY(8000,1) NOT NULL,
	[MAH_NAME] [varchar](30) NULL,
	[MAH_DESCRIPTION] [varchar](100) NULL,
	[MAH_PLANT_ID] [int] NULL,
	[MAH_BLDG_ID] [int] NULL,
	[MAH_PRIORITY] [int] NULL,
	[MAH_STATUS_CODE] [varchar](1) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[MAH_DATE_COMPLETED] [date] NULL,
	[MAH_TIME_COMPLETED] [time](7) NULL,
	[MAH_USER_COMPLETED] [varchar](20) NULL,
	[MAH_HOLD_CODE] [varchar](1) NULL,
	[MAH_DATE_HELD] [date] NULL,
	[MAH_TIME_HELD] [time](7) NULL,
	[MAH_USER_HELD] [varchar](20) NULL,
	[MAH_EST_HOLD_RESOLVED_DATE] [date] NULL,
	[MAH_ACT_HOLD_RESOLVED_DATE] [date] NULL,
	[MAH_ACT_HOLD_RESOLVED_TIME] [time](7) NULL,
	[MAH_COUNT_OPEN_ITEMS] [int] NULL,
	[MAH_COUNT_FAILED_ITEMS] [int] NULL,
	[MAH_COUNT_PASSED_ITEMS] [int] NULL,
	[MAH_COUNT_DISP_ITEMS] [int] NULL,
	[MAH_COUNT_NA_ITEMS] [int] NULL,
	[MAH_COUNT_TOTAL_ITEMS] [int] NULL,
	[MAH_COMPLETE_ERROR] [varchar](100) NULL,
	[MAH_ACT_HOLD_RESOLVED_USER] [varchar](20) NULL,
	[MAH_COUNT_EVER_FAILED_ITEMS] [int] NULL,
	[MAH_AUDIT_DATE] [date] NULL,
	[MAH_PRODUCTION_LINE] [int] NULL,
 CONSTRAINT [PK_MAH_AUDIT_ID] PRIMARY KEY CLUSTERED 
(
	[MAH_AUDIT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_audit_item_vehicles]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_audit_item_vehicles]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_audit_item_vehicles](
	[MAIV_RECORD_ID] [int] IDENTITY(200000,1) NOT NULL,
	[MAIV_MAI_RECORD_ID] [int] NOT NULL,
	[MAIV_SEQUENCE] [int] NULL,
	[MAIV_ORDER_NO] [varchar](10) NULL,
	[MAIV_VIN_NO] [varchar](50) NULL,
	[MAIV_CHASSIS_VIN_NO] [varchar](50) NULL,
	[MAIV_FLOORPLAN_ID] [int] NULL,
	[MAIV_PASS_STANDARD] [varchar](256) NULL,
	[MAIV_FAIL_STANDARD] [varchar](256) NULL,
	[MAIV_REQUIRES_TEST] [varchar](1) NULL,
	[MAIV_TEST_INSTRUCTION] [varchar](512) NULL,
	[MAIV_TEST_START_DATE] [date] NULL,
	[MAIV_TEST_START_TIME] [time](7) NULL,
	[MAIV_TEST_END_DATE] [date] NULL,
	[MAIV_TEST_END_TIME] [time](7) NULL,
	[MAIV_TEST_RESULT_EXPECTED] [varchar](30) NULL,
	[MAIV_TEST_RESULT_ACTUAL] [varchar](30) NULL,
	[MAIV_TEST_USER] [varchar](20) NULL,
	[MAIV_RESULT_CODE] [varchar](1) NULL,
	[MAIV_HAS_EVER_FAILED] [varchar](1) NULL,
	[MAIV_STATUS_CODE] [varchar](1) NULL,
	[MAIV_FAIL_PIC] [image] NULL,
	[MAIV_FAIL_TEXT] [varchar](100) NULL,
	[MAIV_PASS_PIC] [image] NULL,
	[MAIV_PASS_TEXT] [varchar](100) NULL,
	[MAIV_DISP_PIC] [image] NULL,
	[MAIV_DISP_TEXT] [varchar](100) NULL,
	[MAIV_DISP_SIGNATURE] [image] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](20) NULL,
	[MAIV_TEST_RESULT_CODE] [varchar](1) NULL,
	[MAIV_TEST_START_TIME_SERVER] [time](7) NULL,
	[MAIV_TEST_END_TIME_SERVER] [time](7) NULL,
	[MAIV_TEST_EXPECTED_DURATION] [int] NULL,
 CONSTRAINT [PK_MAIV] PRIMARY KEY CLUSTERED 
(
	[MAIV_RECORD_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_audit_items]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_audit_items]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_audit_items](
	[MAI_RECORD_ID] [int] IDENTITY(100000,1) NOT NULL,
	[MAI_AUDIT_ID] [int] NOT NULL,
	[MAI_ITEM_ID] [int] NOT NULL,
	[MAI_DEPARTMENT_ID] [int] NULL,
	[MAI_SEQUENCE] [int] NULL,
	[MAI_PASS_STANDARD] [varchar](256) NULL,
	[MAI_FAIL_STANDARD] [varchar](256) NULL,
	[MAI_REQUIRES_TEST] [varchar](1) NULL,
	[MAI_TEST_INSTRUCTION] [varchar](512) NULL,
	[MAI_TEST_RESULT_EXPECTED] [varchar](30) NULL,
	[MAI_TEST_EXPECTED_DURATION] [int] NULL,
	[MAI_STATUS_CODE] [varchar](1) NULL,
	[MAI_NBR_VEHICLES] [int] NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](20) NULL,
	[MAI_MAP_RECORD_ID] [int] NULL,
	[MAI_MAP_AUDIT_FREQ_CODE] [nchar](1) NULL,
	[MAI_PRODUCTION_LINE] [int] NULL,
 CONSTRAINT [PK_MAI] PRIMARY KEY CLUSTERED 
(
	[MAI_RECORD_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_audit_plan]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_audit_plan]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_audit_plan](
	[MAP_RECORD_ID] [int] IDENTITY(30000,1) NOT NULL,
	[MAP_ITEM_ID] [int] NOT NULL,
	[MAP_DEPARTMENT_ID] [int] NULL,
	[MAP_SEQUENCE] [int] NULL,
	[MAP_PASS_STANDARD] [varchar](256) NULL,
	[MAP_FAIL_STANDARD] [varchar](256) NULL,
	[MAP_TEST_CODE] [varchar](1) NULL,
	[MAP_TEST_INSTRUCTION] [varchar](512) NULL,
	[MAP_TEST_RESULT_EXPECTED] [varchar](30) NULL,
	[MAP_TEST_EXPECTED_DURATION] [int] NULL,
	[MAP_STATUS_CODE] [varchar](1) NULL,
	[MAP_NBR_VEHICLES] [int] NOT NULL,
	[MAP_AUDIT_FREQ_CODE] [varchar](1) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](20) NULL,
	[MAP_LAST_AUDIT_DATE] [date] NULL,
	[MAP_AUDIT_SELECTED] [int] NULL,
	[MAP_AUDIT_RAND_SEQ] [int] NULL,
	[MAP_AUDIT_NEWID] [nvarchar](36) NULL,
	[MAP_PRODUCTION_LINE] [int] NULL,
 CONSTRAINT [PK_MAP] PRIMARY KEY CLUSTERED 
(
	[MAP_RECORD_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_company_code]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_company_code]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_company_code](
	[CC_COMPANY_CODE_ID] [int] IDENTITY(100,1) NOT NULL,
	[CC_COMPANY_CODE_NAME] [varchar](50) NULL,
	[CC_COMPANY_CODE_DESCRIPTION] [varchar](256) NULL,
	[CC_COMPANY_CODE_TEXT] [varchar](50) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Company_Code] PRIMARY KEY CLUSTERED 
(
	[CC_COMPANY_CODE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_connection_test]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_connection_test]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_connection_test](
	[a] [char](1) NULL
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_customer_order]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_customer_order]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_customer_order](
	[CO_ORDER_NO] [int] IDENTITY(501,1) NOT NULL,
	[CO_VIN_NO] [varchar](50) NOT NULL,
	[CO_MODEL_ID] [int] NOT NULL,
	[CO_FLOORPLAN_ID] [int] NULL,
	[CO_ORDER_STATUS] [varchar](50) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CO_MODEL_NAME] [varchar](50) NULL,
	[CO_FLOORPLAN_NAME] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Customer_Order] PRIMARY KEY CLUSTERED 
(
	[CO_ORDER_NO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_cvpl_item]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_cvpl_item]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_cvpl_item](
	[item_id] [int] IDENTITY(1,1) NOT NULL,
	[item_os] [int] NULL,
	[item_launcher] [nvarchar](100) NULL,
	[item_view] [nvarchar](100) NULL,
	[item_details] [nvarchar](4000) NULL,
	[item_status] [int] NULL,
	[item_created] [datetime] NULL,
	[item_created_by] [nvarchar](80) NULL,
	[item_updated] [datetime] NULL,
	[item_updated_by] [nvarchar](80) NULL,
	[project_id] [int] NULL,
 CONSTRAINT [PK_cvpl_item] PRIMARY KEY CLUSTERED 
(
	[item_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[inspect_cvpl_item_note]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_cvpl_item_note]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_cvpl_item_note](
	[note_id] [int] IDENTITY(1,1) NOT NULL,
	[item_id] [int] NOT NULL,
	[note_text] [nvarchar](4000) NULL,
	[note_created] [datetime] NULL,
	[note_created_by] [nvarchar](80) NULL,
 CONSTRAINT [PK_cvpl_item_note] PRIMARY KEY CLUSTERED 
(
	[note_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[inspect_cvpl_os]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_cvpl_os]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_cvpl_os](
	[os_id] [int] IDENTITY(1,1) NOT NULL,
	[os_name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_cvpl_os] PRIMARY KEY CLUSTERED 
(
	[os_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[inspect_cvpl_project]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_cvpl_project]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_cvpl_project](
	[project_id] [int] IDENTITY(1,1) NOT NULL,
	[project_name] [nvarchar](50) NOT NULL,
	[project_active] [int] NOT NULL,
 CONSTRAINT [PK_cvpl_project] PRIMARY KEY CLUSTERED 
(
	[project_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[inspect_cvpl_status]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_cvpl_status]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_cvpl_status](
	[status_id] [int] IDENTITY(1,1) NOT NULL,
	[status_name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_cvpl_status] PRIMARY KEY CLUSTERED 
(
	[status_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[inspect_event_codes]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_event_codes]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_event_codes](
	[EC_CODE] [varchar](3) NOT NULL,
	[EC_NAME] [varchar](20) NULL,
	[EC_DESCRIPTION] [varchar](256) NULL,
	[EC_TEXT] [varchar](50) NULL,
	[EC_STATUS] [varchar](50) NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Event_Code] PRIMARY KEY CLUSTERED 
(
	[EC_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_event_journal]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_event_journal]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_event_journal](
	[FIEJ_EVENT_ID] [int] IDENTITY(300000,1) NOT NULL,
	[FIEJ_INSPECTION_ID] [int] NULL,
	[FIEJ_FII_RECORD_ID] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[FIEJ_EVENT_DATE] [date] NULL,
	[FIEJ_EVENT_TIME] [time](7) NULL,
	[FIEJ_EVENT_USER] [varchar](20) NULL,
	[FIEJ_EVENT_CODE] [varchar](3) NULL,
 CONSTRAINT [PK_VFI_FIEJ] PRIMARY KEY CLUSTERED 
(
	[FIEJ_EVENT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_final_inspection_header]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_final_inspection_header]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_final_inspection_header](
	[FIH_INSPECTION_ID] [int] IDENTITY(8000,1) NOT NULL,
	[FIH_NAME] [varchar](30) NULL,
	[FIH_DESCRIPTION] [varchar](100) NULL,
	[FIH_PLANT_ID] [int] NULL,
	[FIH_BLDG_ID] [int] NULL,
	[FIH_INSPECTION_CELL] [int] NULL,
	[FIH_PRIORITY] [int] NULL,
	[FIH_SHIP_DATE] [date] NULL,
	[FIH_STATUS_CODE] [varchar](1) NULL,
	[FIH_VIN_NO] [varchar](50) NULL,
	[FIH_CHASSIS_VIN_NO] [varchar](50) NULL,
	[FIH_MODEL_ID] [int] NOT NULL,
	[FIH_ORDER_MODEL_CODE] [varchar](50) NULL,
	[FIH_FLOORPLAN_ID] [int] NOT NULL,
	[FIH_ORDER_FLOORPLAN_CODE] [varchar](50) NULL,
	[FIH_ORDER_NO] [varchar](50) NULL,
	[FIH_INSPECTION_PLAN_ID] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[FIH_DATE_PASSED] [date] NULL,
	[FIH_TIME_PASSED] [time](7) NULL,
	[FIH_USER_PASSED] [varchar](20) NULL,
	[FIH_DATE_RELEASED] [date] NULL,
	[FIH_TIME_RELEASED] [time](7) NULL,
	[FIH_USER_RELEASED] [varchar](20) NULL,
	[FIH_HOLD_CODE] [varchar](1) NULL,
	[FIH_DATE_HELD] [date] NULL,
	[FIH_TIME_HELD] [time](7) NULL,
	[FIH_USER_HELD] [varchar](20) NULL,
	[FIH_EST_HOLD_RESOLVED_DATE] [date] NULL,
	[FIH_ACT_HOLD_RESOLVED_DATE] [date] NULL,
	[FIH_ACT_HOLD_RESOLVED_TIME] [time](7) NULL,
	[FIH_COUNT_OPEN_ITEMS] [int] NULL,
	[FIH_COUNT_FAILED_ITEMS] [int] NULL,
	[FIH_COUNT_PASSED_ITEMS] [int] NULL,
	[FIH_COUNT_DISP_ITEMS] [int] NULL,
	[FIH_COUNT_NA_ITEMS] [int] NULL,
	[FIH_COUNT_TOTAL_ITEMS] [int] NULL,
	[FIH_RELEASE_ERROR] [varchar](100) NULL,
	[FIH_ACT_HOLD_RESOLVED_USER] [varchar](20) NULL,
	[FIH_COUNT_EVER_FAILED_ITEMS] [int] NULL,
	[FIH_NOTIFIED] [int] NULL,
 CONSTRAINT [PK_VFI_FIH_INSPECTION_ID] PRIMARY KEY CLUSTERED 
(
	[FIH_INSPECTION_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_final_inspection_item_choices]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_final_inspection_item_choices]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_final_inspection_item_choices](
	[FIIC_UNIQUE_ID] [int] IDENTITY(200000,1) NOT NULL,
	[FIIC_IC_UNIQUE_ID] [int] NULL,
	[FIIC_FII_RECORD_ID] [int] NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[FIIC_INSPECTION_ID] [int] NULL,
	[FIIC_IPI_ID] [int] NULL,
 CONSTRAINT [PK_VFI_FIIC] PRIMARY KEY CLUSTERED 
(
	[FIIC_UNIQUE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_final_inspection_items]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_final_inspection_items]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_final_inspection_items](
	[FII_RECORD_ID] [int] IDENTITY(100000,1) NOT NULL,
	[FII_INSPECTION_ID] [int] NOT NULL,
	[FII_INSPECTION_PLAN_ID] [int] NULL,
	[FII_ITEM_ID] [int] NOT NULL,
	[FII_DEPT_ID] [int] NULL,
	[FII_FEATURE_ID] [int] NULL,
	[FII_ZONE_ID] [int] NULL,
	[FII_LOCATION_ID] [int] NULL,
	[FII_SEQUENCE] [int] NULL,
	[FII_PASS_STANDARD] [varchar](256) NULL,
	[FII_FAIL_STANDARD] [varchar](256) NULL,
	[FII_REQUIRES_TEST] [varchar](1) NULL,
	[FII_TEST_INSTRUCTION] [varchar](512) NULL,
	[FII_TEST_START_DATE] [date] NULL,
	[FII_TEST_START_TIME] [time](7) NULL,
	[FII_TEST_END_DATE] [date] NULL,
	[FII_TEST_END_TIME] [time](7) NULL,
	[FII_TEST_RESULT_EXPECTED] [varchar](30) NULL,
	[FII_TEST_RESULT_ACTUAL] [varchar](30) NULL,
	[FII_TEST_USER] [varchar](20) NULL,
	[FII_RESULT_CODE] [varchar](1) NULL,
	[FII_HAS_EVER_FAILED] [varchar](1) NULL,
	[FII_STATUS_CODE] [varchar](1) NULL,
	[FII_FAIL_PIC] [image] NULL,
	[FII_FAIL_TEXT] [varchar](512) NULL,
	[FII_PASS_PIC] [image] NULL,
	[FII_PASS_TEXT] [varchar](100) NULL,
	[FII_DISP_PIC] [image] NULL,
	[FII_DISP_TEXT] [varchar](100) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](20) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](20) NULL,
	[FII_IPI_ID] [int] NULL,
	[FII_TEST_RESULT_CODE] [varchar](1) NULL,
	[FII_TEST_START_TIME_SERVER] [time](7) NULL,
	[FII_TEST_END_TIME_SERVER] [time](7) NULL,
	[FII_TEST_EXPECTED_DURATION] [int] NULL,
	[FII_RESULT_TYPE] [varchar](1) NULL,
	[FII_RESULT_GRADE] [varchar](1) NULL,
 CONSTRAINT [PK_VFI_FII] PRIMARY KEY CLUSTERED 
(
	[FII_RECORD_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_hold_codes]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_hold_codes]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_hold_codes](
	[HC_CODE] [varchar](1) NOT NULL,
	[HC_NAME] [varchar](20) NULL,
	[HC_DESCRIPTION] [varchar](256) NULL,
	[HC_TEXT] [varchar](50) NULL,
	[HC_STATUS] [varchar](50) NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Hold_Code] PRIMARY KEY CLUSTERED 
(
	[HC_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_inspection_plan]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_inspection_plan]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_inspection_plan](
	[IP_INSPECTION_PLAN_ID] [int] IDENTITY(50000,1) NOT NULL,
	[IP_NAME] [varchar](50) NULL,
	[IP_DESCRIPTION] [varchar](50) NULL,
	[IP_TEXT] [varchar](50) NULL,
	[IP_STATUS] [varchar](50) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[IP_SEQUENCE] [int] NULL,
	[IP_LOCATION_ID] [int] NULL,
	[IP_INSPECTION_TYPE_ID] [int] NULL,
	[IP_XREF_PLAN] [varchar](1) NULL,
 CONSTRAINT [PK_VFI_Inspection_Plan] PRIMARY KEY CLUSTERED 
(
	[IP_INSPECTION_PLAN_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_inspection_plan_items]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_inspection_plan_items]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_inspection_plan_items](
	[IPI_ID] [int] IDENTITY(120000,1) NOT NULL,
	[IPI_INSPECTION_PLAN_ID] [int] NOT NULL,
	[IPI_ITEM_ID] [int] NOT NULL,
	[IPI_SEQUENCE] [int] NULL,
	[IPI_STATUS] [varchar](50) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[IPI_FEATURE_ID] [int] NULL,
	[IPI_ZONE_ID] [int] NULL,
	[IPI_LOCATION_ID] [int] NULL,
 CONSTRAINT [PK_VFI_Inspection_Plan_Items] PRIMARY KEY CLUSTERED 
(
	[IPI_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_inspection_type]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_inspection_type]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_inspection_type](
	[IT_ID] [int] IDENTITY(9701,1) NOT NULL,
	[IT_NAME] [varchar](50) NULL,
	[IT_DESCRIPTION] [varchar](256) NULL,
	[IT_TEXT] [varchar](50) NULL,
	[IT_STATUS] [varchar](50) NOT NULL,
	[IT_SEQUENCE] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Inspection_Type] PRIMARY KEY CLUSTERED 
(
	[IT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_item_choices]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_item_choices]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_item_choices](
	[IC_Unique_ID] [int] IDENTITY(10001,1) NOT NULL,
	[IC_Item_ID] [int] NOT NULL,
	[IC_Choice_ID] [int] NOT NULL,
	[IC_Seq_No] [int] NULL,
	[IC_Description] [varchar](50) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Item_Choices] PRIMARY KEY CLUSTERED 
(
	[IC_Unique_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_item_linked_departments]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_item_linked_departments]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_item_linked_departments](
	[ILD_Unique_ID] [int] IDENTITY(10001,1) NOT NULL,
	[ILD_Item_ID] [int] NOT NULL,
	[ILD_Department_ID] [int] NOT NULL,
	[ILD_Seq_No] [int] NULL,
	[ILD_Description] [varchar](50) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Item_Linked_Departments] PRIMARY KEY CLUSTERED 
(
	[ILD_Unique_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_choices]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_choices]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_choices](
	[MC_CHOICE_ID] [int] IDENTITY(6001,1) NOT NULL,
	[MC_NAME] [varchar](50) NULL,
	[MC_DESCRIPTION] [varchar](50) NULL,
	[MC_TEXT] [varchar](50) NULL,
	[MC_STATUS] [varchar](50) NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[MC_SEQUENCE] [int] NULL,
 CONSTRAINT [PK_VFI_Master_Choices] PRIMARY KEY CLUSTERED 
(
	[MC_CHOICE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_departments]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_departments]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_departments](
	[MD_DEPARTMENT_ID] [int] IDENTITY(2501,1) NOT NULL,
	[MD_NAME] [varchar](50) NULL,
	[MD_DESCRIPTION] [varchar](256) NULL,
	[MD_TEXT] [varchar](50) NULL,
	[MD_STATUS] [varchar](50) NOT NULL,
	[MD_SEQUENCE] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Master_Departments] PRIMARY KEY CLUSTERED 
(
	[MD_DEPARTMENT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_features]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_features]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_features](
	[MF_FEATURE_ID] [int] IDENTITY(4501,1) NOT NULL,
	[MF_FEATURE_ZONE_ID] [int] NOT NULL,
	[MF_NAME] [varchar](50) NULL,
	[MF_DESCRIPTION] [varchar](256) NULL,
	[MF_TEXT] [varchar](50) NULL,
	[MF_STATUS] [varchar](50) NOT NULL,
	[MF_SEQUENCE] [int] NULL,
	[MF_PICTURE] [image] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Master_Features] PRIMARY KEY CLUSTERED 
(
	[MF_FEATURE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_items]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_items]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_items](
	[MI_ITEM_ID] [int] IDENTITY(5001,1) NOT NULL,
	[MI_NAME] [varchar](50) NULL,
	[MI_DESCRIPTION] [varchar](256) NULL,
	[MI_TEXT] [varchar](50) NULL,
	[MI_STATUS] [varchar](50) NOT NULL,
	[MI_CATEGORY] [varchar](50) NULL,
	[MI_PICTURE] [image] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[MI_DEPARTMENT_ID] [int] NULL,
	[MI_TEST_CODE] [varchar](1) NULL,
	[MI_TEST_INSTRUCTION] [varchar](512) NULL,
	[MI_TEST_EXPECTED_RESULT] [varchar](30) NULL,
	[MI_USAGE_CLASS] [nchar](1) NULL,
	[MI_TEST_DURATION] [int] NULL,
	[MI_RESULT_TYPE] [varchar](1) NULL,
	[MI_RESULT_GRADE] [varchar](1) NULL,
 CONSTRAINT [PK_VFI_Master_Items] PRIMARY KEY CLUSTERED 
(
	[MI_ITEM_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_locations]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_locations]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_locations](
	[ML_LOCATION_ID] [int] IDENTITY(2501,1) NOT NULL,
	[ML_NAME] [varchar](50) NULL,
	[ML_DESCRIPTION] [varchar](256) NULL,
	[ML_TEXT] [varchar](50) NULL,
	[ML_STATUS] [varchar](50) NOT NULL,
	[ML_SEQUENCE] [int] NULL,
	[ML_PICTURE] [image] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Master_Locations] PRIMARY KEY CLUSTERED 
(
	[ML_LOCATION_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_models]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_models]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_models](
	[MM_MODEL_ID] [int] IDENTITY(3001,1) NOT NULL,
	[MM_NAME] [varchar](50) NULL,
	[MM_DESCRIPTION] [varchar](50) NULL,
	[MM_TEXT] [varchar](50) NULL,
	[MM_STATUS] [varchar](50) NOT NULL,
	[MM_PICTURE] [image] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[MM_SEQUENCE] [int] NULL,
	[MM_PRODUCTION_LINE_ID] [int] NULL,
 CONSTRAINT [PK_VFI_Master_Models] PRIMARY KEY CLUSTERED 
(
	[MM_MODEL_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_master_zones]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_master_zones]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_master_zones](
	[MZ_ZONE_ID] [int] IDENTITY(3501,1) NOT NULL,
	[MZ_ZONE_LOCATION_ID] [int] NOT NULL,
	[MZ_NAME] [varchar](50) NULL,
	[MZ_DESCRIPTION] [varchar](256) NULL,
	[MZ_TEXT] [varchar](50) NULL,
	[MZ_STATUS] [varchar](50) NOT NULL,
	[MZ_SEQUENCE] [int] NULL,
	[MZ_PICTURE] [image] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[LAST_UPDATE_DATE] [date] NULL,
	[LAST_UPDATE_TIME] [time](7) NULL,
	[LAST_UPDATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Master_Zones] PRIMARY KEY CLUSTERED 
(
	[MZ_ZONE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_model_floorplan_inspection_types]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_model_floorplan_inspection_types]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_model_floorplan_inspection_types](
	[MFIT_ID] [int] IDENTITY(9000,1) NOT NULL,
	[MFIT_FLOORPLAN_ID] [int] NOT NULL,
	[MFIT_INSPECTION_TYPE_ID] [int] NOT NULL,
	[MFIT_INSPECTION_PLAN_ID] [int] NOT NULL,
	[MFIT_STATUS] [varchar](50) NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[MFIT_SEQUENCE] [int] NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_MFIT] PRIMARY KEY CLUSTERED 
(
	[MFIT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_model_floorplans]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_model_floorplans]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_model_floorplans](
	[MF_FLOORPLAN_ID] [int] IDENTITY(3500,1) NOT NULL,
	[MF_NAME] [varchar](50) NULL,
	[MF_MODEL_ID] [int] NOT NULL,
	[MF_DESCRIPTION] [varchar](50) NULL,
	[MF_TEXT] [varchar](50) NULL,
	[MF_STATUS] [varchar](50) NOT NULL,
	[MF_PICTURE] [image] NULL,
	[MF_INSPECTION_PLAN_ID] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[MF_SEQUENCE] [int] NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Model_Floorplans] PRIMARY KEY CLUSTERED 
(
	[MF_FLOORPLAN_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_production_line]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_production_line]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_production_line](
	[PL_PRODUCTION_LINE_ID] [int] IDENTITY(200,1) NOT NULL,
	[PL_PRODUCTION_LINE_NAME] [varchar](50) NULL,
	[PL_PRODUCTION_LINE_DESCRIPTION] [varchar](256) NULL,
	[PL_PRODUCTION_LINE_TEXT] [varchar](50) NULL,
	[PL_PRODUCTION_LINE_STATUS] [varchar](50) NOT NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
 CONSTRAINT [PK_VFI_Production_Line] PRIMARY KEY CLUSTERED 
(
	[PL_PRODUCTION_LINE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_upload_audit_items]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_upload_audit_items]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_upload_audit_items](
	[COMPANY_CODE] [varchar](10) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[MI_DESCRIPTION] [varchar](256) NULL,
	[MI_TEXT] [varchar](50) NULL,
	[MI_NAME] [varchar](50) NULL,
	[MI_DEPARTMENT_ID] [int] NULL,
	[MI_CATEGORY] [varchar](50) NULL,
	[MI_ZONE_ID] [varchar](50) NULL,
	[MI_LOCATION_ID] [varchar](50) NULL,
	[MI_TEST_CODE] [varchar](1) NULL,
	[MI_USAGE_CLASS] [varchar](1) NULL
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_upload_audit_plan]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_upload_audit_plan]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_upload_audit_plan](
	[Item] [int] NULL,
	[Dept] [int] NULL,
	[NV] [int] NULL,
	[FRQ] [varchar](1) NULL,
	[Seq] [int] NULL,
	[Test] [varchar](1) NULL
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_user_position]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_user_position]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_user_position](
	[user_id] [varchar](40) NOT NULL,
	[user_name] [varchar](60) NULL,
	[user_inspection_station] [varchar](20) NULL,
	[user_active] [varchar](1) NULL,
 CONSTRAINT [PK_VFI_User_Position] PRIMARY KEY CLUSTERED 
(
	[user_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_vehicle_inspection]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_vehicle_inspection]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_vehicle_inspection](
	[VI_INSPECTION_ID] [int] IDENTITY(80000,1) NOT NULL,
	[VI_NAME] [varchar](50) NULL,
	[VI_DESCRIPTION] [varchar](50) NULL,
	[VI_STATUS] [varchar](50) NULL,
	[VI_VIN_NO] [varchar](50) NULL,
	[VI_MODEL_ID] [int] NOT NULL,
	[VI_FLOORPLAN_ID] [int] NOT NULL,
	[VI_INSPECTION_DATETIME] [datetime] NOT NULL,
	[VI_ORDER_NO] [varchar](50) NULL,
	[VI_INSPECTION_PLAN_ID] [int] NULL,
	[COMPANY_CODE] [varchar](10) NULL,
	[STAGE] [varchar](10) NULL,
	[CREATE_DATE] [date] NULL,
	[CREATE_TIME] [time](7) NULL,
	[CREATE_USER] [varchar](50) NULL,
	[DATE_PASSED] [date] NULL,
	[TIME_PASSED] [time](7) NULL,
	[DATE_RELEASED] [date] NULL,
	[TIME_RELEASED] [time](7) NULL,
	[HOLD_CODE] [varchar](1) NULL,
	[EST_HOLD_RESOLVE_DATE] [date] NULL,
	[ACT_HOLD_RESOLVE_DATE] [date] NULL,
	[ACT_HOLD_RESOLVE_TIME] [time](7) NULL,
 CONSTRAINT [PK_VFI_VI_INSPECTION_ID] PRIMARY KEY CLUSTERED 
(
	[VI_INSPECTION_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[inspect_vehicle_inspection_detail]    Script Date: 2/21/2019 5:28:35 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[inspect_vehicle_inspection_detail]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[inspect_vehicle_inspection_detail](
	[VID_INSPECTION_ID] [int] NOT NULL,
	[VID_ITEM_ID] [int] NOT NULL,
	[VID_PASSFAIL] [varchar](50) NULL,
	[VID_STATUS] [varchar](50) NULL,
	[VID_FAIL_PIC] [image] NULL,
	[VID_FAIL_TEXT] [varchar](50) NULL,
	[COMPANY_CODE] [varchar](10) NULL,
 CONSTRAINT [PK_VFI_VID_INSPECTION_Detail] PRIMARY KEY CLUSTERED 
(
	[VID_INSPECTION_ID] ASC,
	[VID_ITEM_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_PADDING ON
GO
/****** Object:  Index [UIX_Order_No_Inspection_Plan]    Script Date: 2/21/2019 5:28:35 PM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[inspect_final_inspection_header]') AND name = N'UIX_Order_No_Inspection_Plan')
CREATE UNIQUE NONCLUSTERED INDEX [UIX_Order_No_Inspection_Plan] ON [dbo].[inspect_final_inspection_header]
(
	[FIH_ORDER_NO] ASC,
	[FIH_INSPECTION_PLAN_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = ON, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAH_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_header] ADD  CONSTRAINT [DF_MAH_Status]  DEFAULT ('N') FOR [MAH_STATUS_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAH_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_header] ADD  CONSTRAINT [DF_MAH_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAH_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_header] ADD  CONSTRAINT [DF_MAH_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAH_Hold_Code]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_header] ADD  CONSTRAINT [DF_MAH_Hold_Code]  DEFAULT ('N') FOR [MAH_HOLD_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAIV_RESULT_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_item_vehicles] ADD  CONSTRAINT [DF_MAIV_RESULT_CODE]  DEFAULT ('O') FOR [MAIV_RESULT_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAIV_HAS_FAILED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_item_vehicles] ADD  CONSTRAINT [DF_MAIV_HAS_FAILED]  DEFAULT ('N') FOR [MAIV_HAS_EVER_FAILED]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAIV_STATUS_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_item_vehicles] ADD  CONSTRAINT [DF_MAIV_STATUS_CODE]  DEFAULT ('I') FOR [MAIV_STATUS_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAIV_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_item_vehicles] ADD  CONSTRAINT [DF_MAIV_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAIV_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_item_vehicles] ADD  CONSTRAINT [DF_MAIV_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAIV_TEST_RESULT_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_item_vehicles] ADD  CONSTRAINT [DF_MAIV_TEST_RESULT_CODE]  DEFAULT ('O') FOR [MAIV_TEST_RESULT_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAI_STATUS_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_items] ADD  CONSTRAINT [DF_MAI_STATUS_CODE]  DEFAULT ('I') FOR [MAI_STATUS_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAI_Nbr_Vehicles]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_items] ADD  CONSTRAINT [DF_MAI_Nbr_Vehicles]  DEFAULT ((0)) FOR [MAI_NBR_VEHICLES]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAI_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_items] ADD  CONSTRAINT [DF_MAI_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAI_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_items] ADD  CONSTRAINT [DF_MAI_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAP_STATUS_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_plan] ADD  CONSTRAINT [DF_MAP_STATUS_CODE]  DEFAULT ('A') FOR [MAP_STATUS_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAP_NBR_VEHICLES]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_plan] ADD  CONSTRAINT [DF_MAP_NBR_VEHICLES]  DEFAULT ((1)) FOR [MAP_NBR_VEHICLES]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAP_CREATE_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_plan] ADD  CONSTRAINT [DF_MAP_CREATE_DATE]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_MAP_CREATE_TIME]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_audit_plan] ADD  CONSTRAINT [DF_MAP_CREATE_TIME]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Copmany_Code_Create_Date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_company_code] ADD  CONSTRAINT [DF_VFI_Copmany_Code_Create_Date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Copmany_Code_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_company_code] ADD  CONSTRAINT [DF_VFI_Copmany_Code_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Customer_Order]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_customer_order] ADD  CONSTRAINT [DF_VFI_Customer_Order]  DEFAULT ('Active') FOR [CO_ORDER_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_cvpl_item_item_created]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_cvpl_item] ADD  CONSTRAINT [DF_cvpl_item_item_created]  DEFAULT (getdate()) FOR [item_created]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_cvpl_item_item_updated]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_cvpl_item] ADD  CONSTRAINT [DF_cvpl_item_item_updated]  DEFAULT (getdate()) FOR [item_updated]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_cvpl_item_note_note_created]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_cvpl_item_note] ADD  CONSTRAINT [DF_cvpl_item_note_note_created]  DEFAULT (getdate()) FOR [note_created]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_cvpl_project_project_active]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_cvpl_project] ADD  CONSTRAINT [DF_cvpl_project_project_active]  DEFAULT ((1)) FOR [project_active]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_EC_STATUS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_event_codes] ADD  CONSTRAINT [DF_VFI_EC_STATUS]  DEFAULT ('Active') FOR [EC_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_EC_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_event_codes] ADD  CONSTRAINT [DF_VFI_EC_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_EC_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_event_codes] ADD  CONSTRAINT [DF_VFI_EC_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_FIH_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_header] ADD  CONSTRAINT [DF_FIH_Status]  DEFAULT ('N') FOR [FIH_STATUS_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_FIH_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_header] ADD  CONSTRAINT [DF_VFI_FIH_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_FIH_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_header] ADD  CONSTRAINT [DF_VFI_FIH_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_FIH_hold_code]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_header] ADD  CONSTRAINT [DF_FIH_hold_code]  DEFAULT ('N') FOR [FIH_HOLD_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Final_Inspection_Header_FIH_NOTIFIED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_header] ADD  CONSTRAINT [DF_VFI_Final_Inspection_Header_FIH_NOTIFIED]  DEFAULT ((0)) FOR [FIH_NOTIFIED]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_FIIC_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_item_choices] ADD  CONSTRAINT [DF_VFI_FIIC_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_FIIC_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_item_choices] ADD  CONSTRAINT [DF_VFI_FIIC_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_FII_RESULT_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_items] ADD  CONSTRAINT [DF_FII_RESULT_CODE]  DEFAULT ('O') FOR [FII_RESULT_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_FII_HAS_FAILED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_items] ADD  CONSTRAINT [DF_FII_HAS_FAILED]  DEFAULT ('N') FOR [FII_HAS_EVER_FAILED]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_FII_STATUS_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_items] ADD  CONSTRAINT [DF_FII_STATUS_CODE]  DEFAULT ('I') FOR [FII_STATUS_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_FII_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_items] ADD  CONSTRAINT [DF_VFI_FII_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_FII_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_items] ADD  CONSTRAINT [DF_VFI_FII_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_FII_TEST_RESULT_CODE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_final_inspection_items] ADD  CONSTRAINT [DF_FII_TEST_RESULT_CODE]  DEFAULT ('O') FOR [FII_TEST_RESULT_CODE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_HC_STATUS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_hold_codes] ADD  CONSTRAINT [DF_VFI_HC_STATUS]  DEFAULT ('Active') FOR [HC_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_HC_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_hold_codes] ADD  CONSTRAINT [DF_VFI_HC_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_HC_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_hold_codes] ADD  CONSTRAINT [DF_VFI_HC_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Inspection_Plan]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_plan] ADD  CONSTRAINT [DF_VFI_Inspection_Plan]  DEFAULT ('Active') FOR [IP_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Inspection_Plan_Create_Date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_plan] ADD  CONSTRAINT [DF_VFI_Inspection_Plan_Create_Date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Inspection_Plan_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_plan] ADD  CONSTRAINT [DF_VFI_Inspection_Plan_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Inspection_Plan_Item_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_plan_items] ADD  CONSTRAINT [DF_VFI_Inspection_Plan_Item_Status]  DEFAULT ('Active') FOR [IPI_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Inspection_Plan_Item_Create_Date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_plan_items] ADD  CONSTRAINT [DF_VFI_Inspection_Plan_Item_Create_Date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Inspection_Plan_Item_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_plan_items] ADD  CONSTRAINT [DF_VFI_Inspection_Plan_Item_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_IT_STATUS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_type] ADD  CONSTRAINT [DF_VFI_IT_STATUS]  DEFAULT ('Active') FOR [IT_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_IT_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_type] ADD  CONSTRAINT [DF_VFI_IT_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_IT_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_inspection_type] ADD  CONSTRAINT [DF_VFI_IT_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Item_Choices_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_item_choices] ADD  CONSTRAINT [DF_VFI_Item_Choices_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Itemn_Choices_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_item_choices] ADD  CONSTRAINT [DF_VFI_Itemn_Choices_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Item_Linked_Departments_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_item_linked_departments] ADD  CONSTRAINT [DF_VFI_Item_Linked_Departments_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Item_Linked_Departments_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_item_linked_departments] ADD  CONSTRAINT [DF_VFI_Item_Linked_Departments_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Choices]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_choices] ADD  CONSTRAINT [DF_VFI_Master_Choices]  DEFAULT ('Active') FOR [MC_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Choices_Create_Date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_choices] ADD  CONSTRAINT [DF_VFI_Master_Choices_Create_Date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Choices_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_choices] ADD  CONSTRAINT [DF_VFI_Master_Choices_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Department_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_departments] ADD  CONSTRAINT [DF_VFI_Master_Department_Status]  DEFAULT ('Active') FOR [MD_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Department_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_departments] ADD  CONSTRAINT [DF_VFI_Department_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Department_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_departments] ADD  CONSTRAINT [DF_VFI_Department_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Feature_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_features] ADD  CONSTRAINT [DF_VFI_Master_Feature_Status]  DEFAULT ('Active') FOR [MF_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Feature_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_features] ADD  CONSTRAINT [DF_VFI_Feature_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Feature_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_features] ADD  CONSTRAINT [DF_VFI_Feature_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Items]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_items] ADD  CONSTRAINT [DF_VFI_Master_Items]  DEFAULT ('Active') FOR [MI_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Item_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_items] ADD  CONSTRAINT [DF_VFI_Item_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Item_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_items] ADD  CONSTRAINT [DF_VFI_Item_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Items_Result_type]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_items] ADD  CONSTRAINT [DF_VFI_Master_Items_Result_type]  DEFAULT ('B') FOR [MI_RESULT_TYPE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Location_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_locations] ADD  CONSTRAINT [DF_VFI_Master_Location_Status]  DEFAULT ('Active') FOR [ML_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Location_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_locations] ADD  CONSTRAINT [DF_VFI_Location_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Location_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_locations] ADD  CONSTRAINT [DF_VFI_Location_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Models]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_models] ADD  CONSTRAINT [DF_VFI_Master_Models]  DEFAULT ('Active') FOR [MM_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Model_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_models] ADD  CONSTRAINT [DF_VFI_Model_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Model_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_models] ADD  CONSTRAINT [DF_VFI_Model_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Master_Zone_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_zones] ADD  CONSTRAINT [DF_VFI_Master_Zone_Status]  DEFAULT ('Active') FOR [MZ_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Zone_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_zones] ADD  CONSTRAINT [DF_VFI_Zone_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Zone_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_master_zones] ADD  CONSTRAINT [DF_VFI_Zone_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_MFIT_STATUS]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_model_floorplan_inspection_types] ADD  CONSTRAINT [DF_VFI_MFIT_STATUS]  DEFAULT ('Active') FOR [MFIT_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_MFIT_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_model_floorplan_inspection_types] ADD  CONSTRAINT [DF_VFI_MFIT_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_MFIT_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_model_floorplan_inspection_types] ADD  CONSTRAINT [DF_VFI_MFIT_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Model_Floorplans]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_model_floorplans] ADD  CONSTRAINT [DF_VFI_Model_Floorplans]  DEFAULT ('Active') FOR [MF_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Model_Floorplans_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_model_floorplans] ADD  CONSTRAINT [DF_VFI_Model_Floorplans_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Model_Floorplans_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_model_floorplans] ADD  CONSTRAINT [DF_VFI_Model_Floorplans_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Production_Line_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_production_line] ADD  CONSTRAINT [DF_VFI_Production_Line_Status]  DEFAULT ('Active') FOR [PL_PRODUCTION_LINE_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Production_Line_Create_Date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_production_line] ADD  CONSTRAINT [DF_VFI_Production_Line_Create_Date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Production_Line_Create_Time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_production_line] ADD  CONSTRAINT [DF_VFI_Production_Line_Create_Time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Vehicle_Status]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_vehicle_inspection] ADD  CONSTRAINT [DF_VFI_Vehicle_Status]  DEFAULT ('Active') FOR [VI_STATUS]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF__VFI_Vehic__VI_IN__07C12930]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_vehicle_inspection] ADD  CONSTRAINT [DF__VFI_Vehic__VI_IN__07C12930]  DEFAULT (getdate()) FOR [VI_INSPECTION_DATETIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Vehicle_Inspection_Create_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_vehicle_inspection] ADD  CONSTRAINT [DF_VFI_Vehicle_Inspection_Create_date]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [CREATE_DATE]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Vehicle_Inspection_Create_time]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_vehicle_inspection] ADD  CONSTRAINT [DF_VFI_Vehicle_Inspection_Create_time]  DEFAULT (CONVERT([time],getdate(),(0))) FOR [CREATE_TIME]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_PASSFAIL]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_vehicle_inspection_detail] ADD  CONSTRAINT [DF_VFI_PASSFAIL]  DEFAULT ('N') FOR [VID_PASSFAIL]
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_VFI_Vehicle_Inspection_Detail]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[inspect_vehicle_inspection_detail] ADD  CONSTRAINT [DF_VFI_Vehicle_Inspection_Detail]  DEFAULT ('Active') FOR [VID_STATUS]
END

GO

/****** Object:  View [dbo].[inspect_dashboard_fii_base_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_base_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_base_vw]
AS
SELECT        FII_RESULT_CODE AS Result_Code, FII_HAS_EVER_FAILED AS Ever_Failed, CREATE_DATE AS Created_Date, COUNT(*) AS Result_Count
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_RESULT_CODE, FII_HAS_EVER_FAILED, CREATE_DATE


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_vw]
AS
SELECT        CREATE_DATE, COUNT(*) AS Item_Count
FROM            dbo.inspect_final_inspection_items
GROUP BY CREATE_DATE


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_result_pct_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_result_pct_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_result_pct_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_dashboard_fii_base_vw.Created_Date, dbo.inspect_dashboard_fii_base_vw.Result_Code, dbo.inspect_dashboard_fii_base_vw.Ever_Failed, 
                         dbo.inspect_dashboard_fii_base_vw.Result_Count, dbo.inspect_dashboard_fii_count_vw.Item_Count, 
                         dbo.inspect_dashboard_fii_base_vw.Result_Count / CAST(dbo.inspect_dashboard_fii_count_vw.Item_Count AS float) AS Result_Pct
FROM            dbo.inspect_dashboard_fii_base_vw INNER JOIN
                         dbo.inspect_dashboard_fii_count_vw ON dbo.inspect_dashboard_fii_base_vw.Created_Date = dbo.inspect_dashboard_fii_count_vw.CREATE_DATE
ORDER BY dbo.inspect_dashboard_fii_base_vw.Created_Date, dbo.inspect_dashboard_fii_base_vw.Result_Code, dbo.inspect_dashboard_fii_base_vw.Ever_Failed


' 
GO
/****** Object:  View [dbo].[inspect_inspections_not_released_by_order_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_inspections_not_released_by_order_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_inspections_not_released_by_order_vw]
AS
SELECT        TOP (100) PERCENT FIH_ORDER_NO, COUNT(*) AS Not_Released
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_ORDER_NO, FIH_STATUS_CODE
HAVING        (FIH_STATUS_CODE <> ''R'')


' 
GO
/****** Object:  View [dbo].[inspect_inspections_released_by_order_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_inspections_released_by_order_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_inspections_released_by_order_vw]
AS
SELECT        TOP (100) PERCENT FIH_ORDER_NO, COUNT(*) AS Released
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_ORDER_NO, FIH_STATUS_CODE
HAVING        (FIH_STATUS_CODE = ''R'')


' 
GO
/****** Object:  View [dbo].[inspect_order_inspection_count_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_order_inspection_count_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_order_inspection_count_vw]
AS
SELECT        TOP (100) PERCENT FIH_ORDER_NO, COUNT(*) AS Count_Inspections
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_ORDER_NO
ORDER BY FIH_ORDER_NO


' 
GO
/****** Object:  View [dbo].[inspect_orders_released_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_orders_released_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_orders_released_vw]
AS
SELECT        dbo.inspect_order_inspection_count_vw.FIH_ORDER_NO, dbo.inspect_order_inspection_count_vw.Count_Inspections, dbo.inspect_inspections_released_by_order_vw.Released, 
                         dbo.inspect_inspections_not_released_by_order_vw.Not_Released
FROM            dbo.inspect_inspections_released_by_order_vw RIGHT OUTER JOIN
                         dbo.inspect_order_inspection_count_vw ON dbo.inspect_inspections_released_by_order_vw.FIH_ORDER_NO = dbo.inspect_order_inspection_count_vw.FIH_ORDER_NO LEFT OUTER JOIN
                         dbo.inspect_inspections_not_released_by_order_vw ON dbo.inspect_order_inspection_count_vw.FIH_ORDER_NO = dbo.inspect_inspections_not_released_by_order_vw.FIH_ORDER_NO


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_orders_released_detail_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_orders_released_detail_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_orders_released_detail_vw]
AS
SELECT        FIH_DATE_RELEASED, FIH_ORDER_NO
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_ORDER_NO, FIH_DATE_RELEASED, FIH_INSPECTION_PLAN_ID
HAVING        (FIH_DATE_RELEASED IS NOT NULL)' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_orders_released_summary_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_orders_released_summary_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_orders_released_summary_vw]
AS
SELECT        FIH_DATE_RELEASED, COUNT(''dbo.inspect_dashboard_fih_orders_released_detail_vw.*'') AS Nbr_Orders_Released
FROM            dbo.inspect_dashboard_fih_orders_released_detail_vw
GROUP BY FIH_DATE_RELEASED' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_disp_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_disp_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_disp_vw]
AS
SELECT        TOP (100) PERCENT FII_INSPECTION_ID, COUNT(*) AS Count_Disp
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_INSPECTION_ID, FII_RESULT_CODE
HAVING        (FII_RESULT_CODE = ''D'')
ORDER BY FII_INSPECTION_ID' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_na_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_na_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_na_vw]
AS
SELECT        TOP (100) PERCENT FII_INSPECTION_ID, COUNT(*) AS Count_NA
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_INSPECTION_ID, FII_RESULT_CODE
HAVING        (FII_RESULT_CODE = ''N'')
ORDER BY FII_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_nc_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_nc_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_nc_vw]
AS
SELECT        TOP (100) PERCENT FII_INSPECTION_ID, COUNT(*) AS Count_NC
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_INSPECTION_ID, FII_RESULT_CODE
HAVING        (FII_RESULT_CODE = ''F'')
ORDER BY FII_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_open_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_open_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_open_vw]
AS
SELECT        TOP (100) PERCENT FII_INSPECTION_ID, COUNT(*) AS Count_Open
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_INSPECTION_ID, FII_RESULT_CODE
HAVING        (FII_RESULT_CODE = ''O'')
ORDER BY FII_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_pass_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_pass_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_pass_vw]
AS
SELECT        TOP (100) PERCENT FII_INSPECTION_ID, COUNT(*) AS Count_Pass
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_INSPECTION_ID, FII_RESULT_CODE
HAVING        (FII_RESULT_CODE = ''P'')
ORDER BY FII_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_total_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_total_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_total_vw]
AS
SELECT        TOP (100) PERCENT FII_INSPECTION_ID, COUNT(*) AS Count_Total
FROM            dbo.inspect_final_inspection_items
GROUP BY FII_INSPECTION_ID
ORDER BY FII_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fii_count_summary_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fii_count_summary_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fii_count_summary_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_final_inspection_header.FIH_ORDER_NO, dbo.inspect_final_inspection_header.FIH_INSPECTION_ID, dbo.inspect_final_inspection_header.FIH_VIN_NO, 
                         dbo.inspect_final_inspection_header.CREATE_DATE, dbo.inspect_dashboard_fii_count_open_vw.Count_Open, dbo.inspect_dashboard_fii_count_pass_vw.Count_Pass, 
                         dbo.inspect_dashboard_fii_count_na_vw.Count_NA, dbo.inspect_dashboard_fii_count_nc_vw.Count_NC, dbo.inspect_dashboard_fii_count_disp_vw.Count_Disp, 
                         dbo.inspect_dashboard_fii_count_total_vw.Count_Total
FROM            dbo.inspect_final_inspection_header LEFT OUTER JOIN
                         dbo.inspect_dashboard_fii_count_disp_vw ON dbo.inspect_final_inspection_header.FIH_INSPECTION_ID = dbo.inspect_dashboard_fii_count_disp_vw.FII_INSPECTION_ID LEFT OUTER JOIN
                         dbo.inspect_dashboard_fii_count_pass_vw ON dbo.inspect_final_inspection_header.FIH_INSPECTION_ID = dbo.inspect_dashboard_fii_count_Pass_vw.FII_INSPECTION_ID LEFT OUTER JOIN
                         dbo.inspect_dashboard_fii_count_na_vw ON dbo.inspect_final_inspection_header.FIH_INSPECTION_ID = dbo.inspect_dashboard_fii_count_na_vw.FII_INSPECTION_ID LEFT OUTER JOIN
                         dbo.inspect_dashboard_fii_count_nc_vw ON dbo.inspect_final_inspection_header.FIH_INSPECTION_ID = dbo.inspect_dashboard_fii_count_nc_vw.FII_INSPECTION_ID LEFT OUTER JOIN
                         dbo.inspect_dashboard_fii_count_open_vw ON dbo.inspect_final_inspection_header.FIH_INSPECTION_ID = dbo.inspect_dashboard_fii_count_open_vw.FII_INSPECTION_ID LEFT OUTER JOIN
                         dbo.inspect_dashboard_fii_count_total_vw ON dbo.inspect_final_inspection_header.FIH_INSPECTION_ID = dbo.inspect_dashboard_fii_count_total_vw.FII_INSPECTION_ID
ORDER BY dbo.inspect_final_inspection_header.FIH_ORDER_NO, dbo.inspect_final_inspection_header.FIH_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_order_detail_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_order_detail_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_order_detail_vw]
AS
SELECT        CREATE_DATE AS Date_Inspected, FIH_ORDER_NO AS Order_No, COUNT(*) AS Count_Headers
FROM            dbo.inspect_final_inspection_header
GROUP BY CREATE_DATE, FIH_ORDER_NO


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_order_summary_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_order_summary_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_order_summary_vw]
AS
SELECT        Date_Inspected, COUNT(*) AS Nbr_Orders_Inspected
FROM            dbo.inspect_dashboard_fih_order_detail_vw
GROUP BY Date_Inspected


' 
GO
/****** Object:  View [dbo].[inspect_aud_header_sum_veh_reqd_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_header_sum_veh_reqd_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_header_sum_veh_reqd_vw]
AS
SELECT        MAI_AUDIT_ID AS V_AUDIT_ID, SUM(MAI_NBR_VEHICLES) AS TOTAL_SUM_VEH_REQD
FROM            dbo.inspect_audit_items
GROUP BY MAI_AUDIT_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_header_veh_count_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_header_veh_count_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_header_veh_count_vw]
AS
SELECT        dbo.inspect_audit_items.MAI_AUDIT_ID AS AUDIT_ID, COUNT(dbo.inspect_audit_item_vehicles.MAIV_RECORD_ID) AS TOTAL_COUNT_VEH_AUD
FROM            dbo.inspect_audit_items LEFT OUTER JOIN
                         dbo.inspect_audit_item_vehicles ON dbo.inspect_audit_items.MAI_RECORD_ID = dbo.inspect_audit_item_vehicles.MAIV_MAI_RECORD_ID
GROUP BY dbo.inspect_audit_items.MAI_AUDIT_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_header_veh_nc_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_header_veh_nc_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_header_veh_nc_vw]
AS
SELECT        dbo.inspect_audit_items.MAI_AUDIT_ID AS AUDIT_ID, COUNT(dbo.inspect_audit_item_vehicles.MAIV_RECORD_ID) AS TOTAL_COUNT_VEH_NC
FROM            dbo.inspect_audit_items LEFT OUTER JOIN
                         dbo.inspect_audit_item_vehicles ON dbo.inspect_audit_items.MAI_RECORD_ID = dbo.inspect_audit_item_vehicles.MAIV_MAI_RECORD_ID
WHERE        (dbo.inspect_audit_item_vehicles.MAIV_RESULT_CODE = ''F'' OR
                         dbo.inspect_audit_item_vehicles.MAIV_RESULT_CODE IS NULL)
GROUP BY dbo.inspect_audit_items.MAI_AUDIT_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_header_veh_summary_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_header_veh_summary_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_header_veh_summary_vw]
AS
SELECT        dbo.inspect_aud_header_veh_count_vw.AUDIT_ID, dbo.inspect_aud_header_sum_veh_reqd_vw.TOTAL_SUM_VEH_REQD, dbo.inspect_aud_header_veh_count_vw.TOTAL_COUNT_VEH_AUD, 
                         ISNULL(dbo.inspect_aud_header_veh_nc_vw.TOTAL_COUNT_VEH_NC, 0) AS TOTAL_COUNT_NC_VEH
FROM            dbo.inspect_aud_header_veh_count_vw LEFT OUTER JOIN
                         dbo.inspect_aud_header_sum_veh_reqd_vw ON dbo.inspect_aud_header_veh_count_vw.AUDIT_ID = dbo.inspect_aud_header_sum_veh_reqd_vw.V_AUDIT_ID LEFT OUTER JOIN
                         dbo.inspect_aud_header_veh_nc_vw ON dbo.inspect_aud_header_veh_count_vw.AUDIT_ID = dbo.inspect_aud_header_veh_nc_vw.AUDIT_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_count_failed_audit_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_count_failed_audit_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_count_failed_audit_vw]
AS
SELECT        MAIV_MAI_RECORD_ID, COUNT(*) AS Failed_Audit_Count
FROM            dbo.inspect_audit_item_vehicles
WHERE        (MAIV_RESULT_CODE = ''F'')
GROUP BY MAIV_MAI_RECORD_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_count_vehicles_audit_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_count_vehicles_audit_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_count_vehicles_audit_vw]
AS
SELECT        TOP (100) PERCENT MAIV_MAI_RECORD_ID, COUNT(*) AS Vehicles_Audited_Count
FROM            dbo.inspect_audit_item_vehicles
GROUP BY MAIV_MAI_RECORD_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_view_nbr_vehicles_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_view_nbr_vehicles_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_view_nbr_vehicles_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_audit_items.MAI_RECORD_ID, dbo.inspect_audit_items.MAI_ITEM_ID AS [Item ID], dbo.inspect_audit_items.MAI_DEPARTMENT_ID, 
                         ISNULL(dbo.inspect_aud_count_failed_audit_vw.Failed_Audit_Count, 0) AS Count_Failed_Audit, ISNULL(dbo.inspect_aud_count_vehicles_audit_vw.Vehicles_Audited_Count, 0) AS Count_Vehicles_Audited, 
                         dbo.inspect_audit_items.MAI_NBR_VEHICLES
FROM            dbo.inspect_audit_items LEFT OUTER JOIN
                         dbo.inspect_aud_count_vehicles_audit_vw ON dbo.inspect_audit_items.MAI_RECORD_ID = dbo.inspect_aud_count_vehicles_audit_vw.MAIV_MAI_RECORD_ID LEFT OUTER JOIN
                         dbo.inspect_aud_count_failed_audit_vw ON dbo.inspect_audit_items.MAI_RECORD_ID = dbo.inspect_aud_count_failed_audit_vw.MAIV_MAI_RECORD_ID
GROUP BY dbo.inspect_audit_items.MAI_ITEM_ID, dbo.inspect_audit_items.MAI_DEPARTMENT_ID, dbo.inspect_audit_items.MAI_RECORD_ID, dbo.inspect_aud_count_failed_audit_vw.Failed_Audit_Count, 
                         dbo.inspect_aud_count_vehicles_audit_vw.Vehicles_Audited_Count, dbo.inspect_audit_items.MAI_NBR_VEHICLES
ORDER BY dbo.inspect_audit_items.MAI_RECORD_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_view_nbr_vehicles_status_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_view_nbr_vehicles_status_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_view_nbr_vehicles_status_vw]
AS
SELECT        MAI_RECORD_ID, MAI_NBR_VEHICLES, Count_Vehicles_Audited, Count_Failed_Audit, MAI_DEPARTMENT_ID, [Item ID], 
                         CASE WHEN Count_Vehicles_Audited = 0 THEN ''Not Started'' WHEN Count_Vehicles_Audited >= MAI_NBR_VEHICLES THEN ''Completed'' WHEN Count_Vehicles_Audited < MAI_NBR_VEHICLES THEN ''In Process'' END
                          AS ITEM_STATUS
FROM            dbo.inspect_aud_view_nbr_vehicles_vw


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_base_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_base_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_base_vw]
AS
SELECT        CREATE_DATE AS Header_Created, COUNT(*) AS Header_Count
FROM            dbo.inspect_final_inspection_header
GROUP BY CREATE_DATE


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_counts_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_counts_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_counts_vw]
AS
SELECT        CREATE_DATE AS Created_On, SUM(FIH_COUNT_OPEN_ITEMS) AS Open_Items, SUM(FIH_COUNT_FAILED_ITEMS) AS NC_Items, SUM(FIH_COUNT_PASSED_ITEMS) AS Passed_Items, 
                         SUM(FIH_COUNT_DISP_ITEMS) AS Disp_Items, SUM(FIH_COUNT_NA_ITEMS) AS NA_Items, SUM(FIH_COUNT_TOTAL_ITEMS) AS Total_Items, SUM(FIH_COUNT_EVER_FAILED_ITEMS) 
                         AS Ever_Failed_Items
FROM            dbo.inspect_final_inspection_header
GROUP BY CREATE_DATE


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_on_hold_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_on_hold_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_on_hold_vw]
AS
SELECT        FIH_DATE_HELD AS On_Hold_Date, COUNT(*) AS Nbr_Inspections_On_Hold
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_DATE_HELD
HAVING        (FIH_DATE_HELD IS NOT NULL)


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_released_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_released_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_released_vw]
AS
SELECT        FIH_DATE_RELEASED AS Date_Released, COUNT(*) AS Nbr_Inspections_Released
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_DATE_RELEASED
HAVING        (FIH_DATE_RELEASED IS NOT NULL)


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_final_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_final_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_final_vw]
AS
SELECT        dbo.inspect_dashboard_fih_base_vw.Header_Created, dbo.inspect_dashboard_fih_base_vw.Header_Count, dbo.inspect_dashboard_fih_counts_vw.Open_Items, dbo.inspect_dashboard_fih_counts_vw.NC_Items, 
                         dbo.inspect_dashboard_fih_counts_vw.Passed_Items, dbo.inspect_dashboard_fih_counts_vw.Disp_Items, dbo.inspect_dashboard_fih_counts_vw.NA_Items, 
                         dbo.inspect_dashboard_fih_counts_vw.Ever_Failed_Items, dbo.inspect_dashboard_fih_counts_vw.Total_Items, dbo.inspect_dashboard_fih_released_vw.Nbr_Inspections_Released, 
                         dbo.inspect_dashboard_fih_on_hold_vw.Nbr_Inspections_On_Hold, dbo.inspect_dashboard_fih_order_summary_vw.Nbr_Orders_Inspected, 
                         dbo.inspect_dashboard_fih_orders_released_summary_vw.Nbr_Orders_Released
FROM            dbo.inspect_dashboard_fih_base_vw LEFT OUTER JOIN
                         dbo.inspect_dashboard_fih_orders_released_summary_vw ON 
                         dbo.inspect_dashboard_fih_base_vw.Header_Created = dbo.inspect_dashboard_fih_orders_released_summary_vw.FIH_DATE_RELEASED LEFT OUTER JOIN
                         dbo.inspect_dashboard_fih_order_summary_vw ON dbo.inspect_dashboard_fih_base_vw.Header_Created = dbo.inspect_dashboard_fih_order_summary_vw.Date_Inspected LEFT OUTER JOIN
                         dbo.inspect_dashboard_fih_released_vw ON dbo.inspect_dashboard_fih_base_vw.Header_Created = dbo.inspect_dashboard_fih_released_vw.Date_Released LEFT OUTER JOIN
                         dbo.inspect_dashboard_fih_on_hold_vw ON dbo.inspect_dashboard_fih_base_vw.Header_Created = dbo.inspect_dashboard_fih_on_hold_vw.On_Hold_Date LEFT OUTER JOIN
                         dbo.inspect_dashboard_fih_counts_vw ON dbo.inspect_dashboard_fih_base_vw.Header_Created = dbo.inspect_dashboard_fih_counts_vw.Created_On


' 
GO
/****** Object:  View [dbo].[inspect_notification_defects_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_notification_defects_vw]'))
EXEC dbo.sp_executesql @statement = N'
/****** Script for SelectTopNRows command from SSMS  ******/
CREATE VIEW [dbo].[inspect_notification_defects_vw] 
AS
SELECT FIIC.[FIIC_UNIQUE_ID]
      ,FIIC.[FIIC_IC_UNIQUE_ID]
      ,FIIC.[FIIC_FII_RECORD_ID]
      ,FIIC.[COMPANY_CODE]
      ,FIIC.[CREATE_DATE]
      ,FIIC.[CREATE_TIME]
      ,FIIC.[CREATE_USER]
      ,FIIC.[FIIC_INSPECTION_ID]
      ,FIIC.[FIIC_IPI_ID]
	  ,MI1.MI_NAME
	  ,FIH.FIH_ORDER_NO
	  ,FIH.FIH_INSPECTION_PLAN_ID
	  ,IP1.IP_NAME
	  ,MC1.MC_NAME
	  ,FII.FII_DEPT_ID
	  ,ML1.ML_NAME
	  ,MZ1.MZ_NAME
	  ,MF1.MF_NAME
	  ,1 AS DF_COUNT
  FROM [dbo].[inspect_final_inspection_item_choices] AS FIIC
  LEFT OUTER JOIN inspect_final_inspection_header    AS FIH ON
  FIH.FIH_INSPECTION_ID = FIIC.FIIC_INSPECTION_ID
  LEFT OUTER JOIN inspect_final_inspection_items     AS FII ON
  FII.FII_RECORD_ID = FIIC.FIIC_FII_RECORD_ID
  LEFT OUTER JOIN inspect_inspection_plan            AS IP1 ON
  IP1.IP_INSPECTION_PLAN_ID = FIH.FIH_INSPECTION_PLAN_ID
  LEFT OUTER JOIN inspect_item_choices               AS IC1 ON
  IC1.IC_UNIQUE_ID = FIIC.FIIC_IC_UNIQUE_ID
  LEFT OUTER JOIN inspect_master_choices             AS MC1 ON
  MC1.MC_CHOICE_ID = IC1.IC_CHOICE_ID
  LEFT OUTER JOIN inspect_master_items               AS MI1 ON
  MI1.MI_ITEM_ID = FII.FII_ITEM_ID
  LEFT OUTER JOIN inspect_master_locations           AS ML1 ON
  ML1.ML_LOCATION_ID = FII.FII_LOCATION_ID
  LEFT OUTER JOIN inspect_master_zones               AS MZ1 ON
  MZ1.MZ_ZONE_ID = FII.FII_ZONE_ID
  LEFT OUTER JOIN inspect_master_features            AS MF1 ON
  MF1.MF_FEATURE_ID = FII.FII_FEATURE_ID





' 
GO
/****** Object:  View [dbo].[inspect_nofication_defect_sum_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_nofication_defect_sum_vw]'))
EXEC dbo.sp_executesql @statement = N'
/****** Script for SelectTopNRows command from SSMS  ******/
CREATE VIEW [dbo].[inspect_nofication_defect_sum_vw] AS 
SELECT
 --      [FIIC_UNIQUE_ID]
 --     ,[FIIC_IC_UNIQUE_ID]
 --     ,[FIIC_FII_RECORD_ID]
 --     ,[COMPANY_CODE]
 --     ,[CREATE_DATE]
 --     ,[CREATE_TIME]
 --     ,[CREATE_USER]
 --     ,[FIH_INSPECTION_PLAN_ID]
 --     ,[FIIC_IPI_ID]
         FIH_ORDER_NO
        ,FIIC_INSPECTION_ID
        ,IP_NAME
		,MI_NAME
        ,COALESCE([MC_NAME], ''N/A'') AS MC_NAME
        ,FII_DEPT_ID
		,ML_NAME
		,MZ_NAME
		,MF_NAME
        ,SUM([DF_COUNT]) AS [DF_COUNT]
  FROM [dbo].[inspect_notification_defects_vw]
  GROUP BY FIH_ORDER_NO
          ,FIIC_INSPECTION_ID
          ,IP_NAME
		  ,MI_NAME
          ,MC_NAME
          ,FII_DEPT_ID
		  ,ML_NAME
		  ,MZ_NAME
		  ,MF_NAME




' 
GO
/****** Object:  View [dbo].[inspect_department_items_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_department_items_vw]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[inspect_department_items_vw]
AS
SELECT   TOP (100) PERCENT 
         [MI_Item_ID]        AS DI_ITEM_ID
        ,[MI_Department_ID]  AS DI_DEPT_ID
	    ,[MD_DESCRIPTION]    AS DI_DESCRIPTION
		,0                   AS DI_SEQ
FROM     dbo.inspect_master_items
LEFT JOIN dbo.inspect_master_departments
ON       MI_Department_ID = MD_DEPARTMENT_ID
UNION
SELECT   TOP (100) PERCENT 
         [ILD_Item_ID]       AS DI_ITEM_ID
        ,[ILD_Department_ID] AS DI_DEPT_ID
	    ,[MD_DESCRIPTION]    AS DI_DESCRIPTION
		,[ILD_Seq_No]        AS DI_SEQ 
FROM     dbo.inspect_item_linked_departments
LEFT JOIN dbo.inspect_master_departments
ON       ILD_Department_ID = MD_DEPARTMENT_ID





' 
GO
/****** Object:  View [dbo].[inspect_department_linked_items_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_department_linked_items_vw]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[inspect_department_linked_items_vw]
AS
SELECT   TOP (100) PERCENT 
		 ROW_NUMBER() OVER (ORDER BY ML_LOCATION_ID) AS ''Row  Number''
        ,[ML_LOCATION_ID]         AS DLI_ML_LOCATION_ID
        ,[ML_NAME]                AS DLI_ML_NAME
		,[MZ_ZONE_ID]             AS DLI_MZ_ZONE_ID
        ,[MZ_NAME]                AS DLI_MZ_NAME
		,[MF_FEATURE_ID]          AS DLI_MF_FEATURE_ID
        ,[MF_NAME]                AS DLI_MF_NAME
        ,[IPI_INSPECTION_PLAN_ID] AS DLI_IPI_INSPECTION_PLAN_ID
		,[IPI_ITEM_ID]            AS DLI_IPI_ITEM_ID
		,[MI_NAME]                AS DLI_MI_NAME
		,[DI_DEPT_ID]             AS DLI_DEPT_ID
		,[DI_DESCRIPTION]         AS DLI_DEPARTMENT_NAME 
		,[IP_XREF_PLAN]           AS DLI_XREF_PLAN 
FROM     dbo.inspect_master_locations
LEFT JOIN dbo.inspect_master_zones
ON       ML_LOCATION_ID = MZ_ZONE_LOCATION_ID
LEFT JOIN dbo.inspect_master_features
ON       MF_FEATURE_ZONE_ID = MZ_ZONE_ID
LEFT JOIN dbo.inspect_inspection_plan_items
ON       MF_FEATURE_ID = IPI_FEATURE_ID
LEFT JOIN dbo.inspect_master_items
ON       IPI_ITEM_ID = MI_ITEM_ID
LEFT OUTER JOIN dbo.inspect_department_items_vw
ON       IPI_ITEM_ID = DI_ITEM_ID
LEFT OUTER JOIN dbo.inspect_inspection_plan
ON       IP_INSPECTION_PLAN_ID = IPI_INSPECTION_PLAN_ID








' 
GO
/****** Object:  View [dbo].[inspect_aud_count_audit_items_byfreqcode_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_count_audit_items_byfreqcode_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_count_audit_items_byfreqcode_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_audit_header.MAH_AUDIT_ID, dbo.inspect_audit_header.MAH_AUDIT_DATE, dbo.inspect_audit_items.MAI_MAP_AUDIT_FREQ_CODE, 
                         COUNT(dbo.inspect_audit_items.MAI_MAP_RECORD_ID) AS Count_Items
FROM            dbo.inspect_audit_items INNER JOIN
                         dbo.inspect_audit_header ON dbo.inspect_audit_items.MAI_AUDIT_ID = dbo.inspect_audit_header.MAH_AUDIT_ID
GROUP BY dbo.inspect_audit_header.MAH_AUDIT_ID, dbo.inspect_audit_header.MAH_AUDIT_DATE, dbo.inspect_audit_items.MAI_MAP_AUDIT_FREQ_CODE
ORDER BY dbo.inspect_audit_header.MAH_AUDIT_DATE DESC


' 
GO
/****** Object:  View [dbo].[inspect_aud_nbr_vehicles_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_nbr_vehicles_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_nbr_vehicles_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_audit_header.MAH_AUDIT_DATE, dbo.inspect_audit_header.MAH_AUDIT_ID, COUNT(dbo.inspect_audit_item_vehicles.MAIV_VIN_NO) AS Nbr_Vehicles
FROM            dbo.inspect_audit_item_vehicles LEFT OUTER JOIN
                         dbo.inspect_audit_items ON dbo.inspect_audit_item_vehicles.MAIV_MAI_RECORD_ID = dbo.inspect_audit_items.MAI_RECORD_ID RIGHT OUTER JOIN
                         dbo.inspect_audit_header ON dbo.inspect_audit_items.MAI_AUDIT_ID = dbo.inspect_audit_header.MAH_AUDIT_ID
GROUP BY dbo.inspect_audit_header.MAH_AUDIT_ID, dbo.inspect_audit_header.MAH_AUDIT_DATE
ORDER BY dbo.inspect_audit_header.MAH_AUDIT_DATE, dbo.inspect_audit_header.MAH_AUDIT_ID


' 
GO
/****** Object:  View [dbo].[inspect_aud_vfi_orders_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_aud_vfi_orders_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_aud_vfi_orders_vw]
AS
SELECT        MAIV_ORDER_NO AS ORDER_NO
FROM            inspect_audit_item_vehicles
GROUP BY MAIV_ORDER_NO
UNION
SELECT        FIH_ORDER_NO AS ORDER_NO
FROM            inspect_final_inspection_header
GROUP BY FIH_ORDER_NO


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_off_hold_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_off_hold_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_off_hold_vw]
AS
SELECT        FIH_ACT_HOLD_RESOLVED_DATE AS Off_Hold_Date, COUNT(*) AS Off_Hold_Count
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_ACT_HOLD_RESOLVED_DATE, FIH_HOLD_CODE
HAVING        (FIH_HOLD_CODE <> ''N'')


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_fih_orders_count_not_released_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_fih_orders_count_not_released_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_fih_orders_count_not_released_vw]
AS
SELECT        FIH_ORDER_NO, COUNT(*) AS Count_Inspections_Not_Released
FROM            dbo.inspect_final_inspection_header
GROUP BY FIH_ORDER_NO, FIH_DATE_RELEASED
HAVING        (FIH_DATE_RELEASED IS NULL)


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_items_journal_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_items_journal_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_items_journal_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_event_journal.FIEJ_EVENT_DATE, dbo.inspect_event_journal.FIEJ_EVENT_CODE, dbo.inspect_event_codes.EC_NAME, COUNT(*) AS Count
FROM            dbo.inspect_event_journal INNER JOIN
                         dbo.inspect_event_codes ON dbo.inspect_event_journal.FIEJ_EVENT_CODE = dbo.inspect_event_codes.EC_CODE
GROUP BY dbo.inspect_event_journal.FIEJ_EVENT_DATE, dbo.inspect_event_journal.FIEJ_EVENT_CODE, dbo.inspect_event_codes.EC_NAME
HAVING        (dbo.inspect_event_journal.FIEJ_EVENT_CODE > ''200'' AND dbo.inspect_event_journal.FIEJ_EVENT_CODE < ''600'')
ORDER BY dbo.inspect_event_journal.FIEJ_EVENT_DATE, dbo.inspect_event_journal.FIEJ_EVENT_CODE


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_nc_attrib_count_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_nc_attrib_count_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_nc_attrib_count_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_final_inspection_item_choices.CREATE_DATE AS NC_Date, dbo.inspect_final_inspection_item_choices.FIIC_IC_UNIQUE_ID, dbo.inspect_item_choices.IC_Item_ID, 
                         dbo.inspect_item_choices.IC_Choice_ID, dbo.inspect_master_items.MI_NAME AS Item, dbo.inspect_master_choices.MC_NAME AS Attribute, dbo.inspect_master_zones.MZ_ZONE_ID, 
                         dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID, COUNT(*) AS [Nbr of Inspections]
FROM            dbo.inspect_final_inspection_item_choices INNER JOIN
                         dbo.inspect_item_choices ON dbo.inspect_final_inspection_item_choices.FIIC_IC_UNIQUE_ID = dbo.inspect_item_choices.IC_Unique_ID INNER JOIN
                         dbo.inspect_master_items ON dbo.inspect_item_choices.IC_Item_ID = dbo.inspect_master_items.MI_ITEM_ID INNER JOIN
                         dbo.inspect_master_choices ON dbo.inspect_item_choices.IC_Choice_ID = dbo.inspect_master_choices.MC_CHOICE_ID INNER JOIN
                         dbo.inspect_inspection_plan_items ON dbo.inspect_final_inspection_item_choices.FIIC_IPI_ID = dbo.inspect_inspection_plan_items.IPI_ID INNER JOIN
                         dbo.inspect_master_zones ON dbo.inspect_inspection_plan_items.IPI_ZONE_ID = dbo.inspect_master_zones.MZ_ZONE_ID
GROUP BY dbo.inspect_final_inspection_item_choices.CREATE_DATE, dbo.inspect_master_choices.MC_NAME, dbo.inspect_master_items.MI_NAME, dbo.inspect_final_inspection_item_choices.FIIC_IC_UNIQUE_ID, 
                         dbo.inspect_item_choices.IC_Item_ID, dbo.inspect_item_choices.IC_Choice_ID, dbo.inspect_master_zones.MZ_ZONE_ID, dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID
ORDER BY NC_Date, Item, Attribute


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_nc_count_loc_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_nc_count_loc_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_nc_count_loc_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_final_inspection_items.CREATE_DATE, dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID, dbo.inspect_production_line.PL_PRODUCTION_LINE_NAME, COUNT(*) 
                         AS Count_Nbr_NC_Items
FROM            dbo.inspect_production_line INNER JOIN
                         dbo.inspect_master_models ON dbo.inspect_production_line.PL_PRODUCTION_LINE_ID = dbo.inspect_master_models.MM_PRODUCTION_LINE_ID INNER JOIN
                         dbo.inspect_model_floorplans INNER JOIN
                         dbo.inspect_final_inspection_items INNER JOIN
                         dbo.inspect_inspection_plan_items ON dbo.inspect_final_inspection_items.FII_IPI_ID = dbo.inspect_inspection_plan_items.IPI_ID INNER JOIN
                         dbo.inspect_master_items ON dbo.inspect_inspection_plan_items.IPI_ITEM_ID = dbo.inspect_master_items.MI_ITEM_ID INNER JOIN
                         dbo.inspect_master_zones ON dbo.inspect_inspection_plan_items.IPI_ZONE_ID = dbo.inspect_master_zones.MZ_ZONE_ID INNER JOIN
                         dbo.inspect_final_inspection_header ON dbo.inspect_final_inspection_items.FII_INSPECTION_ID = dbo.inspect_final_inspection_header.FIH_INSPECTION_ID ON 
                         dbo.inspect_model_floorplans.MF_FLOORPLAN_ID = dbo.inspect_final_inspection_header.FIH_FLOORPLAN_ID ON dbo.inspect_master_models.MM_MODEL_ID = dbo.inspect_model_floorplans.MF_MODEL_ID
WHERE        (dbo.inspect_final_inspection_items.FII_HAS_EVER_FAILED = ''Y'')
GROUP BY dbo.inspect_final_inspection_items.CREATE_DATE, dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID, dbo.inspect_production_line.PL_PRODUCTION_LINE_NAME
ORDER BY dbo.inspect_final_inspection_items.CREATE_DATE DESC, dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID


' 
GO
/****** Object:  View [dbo].[inspect_dashboard_nc_count_pl_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_dashboard_nc_count_pl_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_dashboard_nc_count_pl_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_final_inspection_items.CREATE_DATE, dbo.inspect_production_line.PL_PRODUCTION_LINE_NAME, COUNT(dbo.inspect_final_inspection_items.FII_RECORD_ID) 
                         AS Count_Nbr_NC_Items
FROM            dbo.inspect_production_line INNER JOIN
                         dbo.inspect_master_models ON dbo.inspect_production_line.PL_PRODUCTION_LINE_ID = dbo.inspect_master_models.MM_PRODUCTION_LINE_ID INNER JOIN
                         dbo.inspect_final_inspection_items INNER JOIN
                         dbo.inspect_final_inspection_header ON dbo.inspect_final_inspection_items.FII_INSPECTION_ID = dbo.inspect_final_inspection_header.FIH_INSPECTION_ID INNER JOIN
                         dbo.inspect_model_floorplans ON dbo.inspect_final_inspection_header.FIH_FLOORPLAN_ID = dbo.inspect_model_floorplans.MF_FLOORPLAN_ID ON 
                         dbo.inspect_master_models.MM_MODEL_ID = dbo.inspect_model_floorplans.MF_MODEL_ID
WHERE        (dbo.inspect_final_inspection_items.FII_HAS_EVER_FAILED = ''Y'')
GROUP BY dbo.inspect_final_inspection_items.CREATE_DATE, dbo.inspect_production_line.PL_PRODUCTION_LINE_NAME
ORDER BY dbo.inspect_final_inspection_items.CREATE_DATE DESC


' 
GO
/****** Object:  View [dbo].[inspect_feature_linked_items_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_feature_linked_items_vw]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[inspect_feature_linked_items_vw]
AS
SELECT   TOP (100) PERCENT 
		 ROW_NUMBER() OVER (ORDER BY ML_LOCATION_ID) AS ''Row  Number''
        ,[ML_LOCATION_ID]         AS FLI_ML_LOCATION_ID
        ,[ML_NAME]                AS FLI_ML_NAME
		,[MZ_ZONE_ID]             AS FLI_MZ_ZONE_ID
        ,[MZ_NAME]                AS FLI_MZ_NAME
		,[MF_FEATURE_ID]          AS FLI_MF_FEATURE_ID
        ,[MF_NAME]                AS FLI_MF_NAME
        ,[IPI_INSPECTION_PLAN_ID] AS FLI_IPI_INSPECTION_PLAN_ID
		,[IPI_ITEM_ID]            AS FLI_IPI_ITEM_ID
		,[MI_NAME]                AS FLI_MI_NAME
		,[IP_XREF_PLAN]           AS FLI_XREF_PLAN
FROM     dbo.inspect_master_locations
LEFT JOIN dbo.inspect_master_zones
ON       ML_LOCATION_ID = MZ_ZONE_LOCATION_ID
LEFT JOIN dbo.inspect_master_features
ON       MF_FEATURE_ZONE_ID = MZ_ZONE_ID
LEFT JOIN dbo.inspect_inspection_plan_items
ON       MF_FEATURE_ID = IPI_FEATURE_ID
LEFT JOIN dbo.inspect_master_items
ON       IPI_ITEM_ID = MI_ITEM_ID
LEFT OUTER JOIN dbo.inspect_inspection_plan
ON       IP_INSPECTION_PLAN_ID = IPI_INSPECTION_PLAN_ID







' 
GO
/****** Object:  View [dbo].[inspect_fii_item_attribs_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_fii_item_attribs_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_fii_item_attribs_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_final_inspection_header.FIH_INSPECTION_ID, dbo.inspect_final_inspection_header.FIH_ORDER_NO, dbo.inspect_master_locations.ML_SEQUENCE, dbo.inspect_master_locations.ML_TEXT, 
                         dbo.inspect_master_zones.MZ_SEQUENCE, dbo.inspect_master_zones.MZ_TEXT, dbo.inspect_final_inspection_items.FII_SEQUENCE, dbo.inspect_master_items.MI_TEXT, dbo.inspect_item_choices.IC_Seq_No, 
                         dbo.inspect_master_choices.MC_TEXT, dbo.inspect_final_inspection_items.FII_RESULT_CODE AS V_FII_RESULT_CODE, dbo.inspect_final_inspection_items.FII_HAS_EVER_FAILED, 
                         dbo.inspect_final_inspection_items.FII_STATUS_CODE, dbo.inspect_master_models.MM_TEXT, dbo.inspect_model_floorplans.MF_TEXT, dbo.inspect_final_inspection_items.FII_IPI_ID, 
                         dbo.inspect_final_inspection_item_choices.FIIC_FII_RECORD_ID, dbo.inspect_final_inspection_item_choices.FIIC_UNIQUE_ID, dbo.inspect_final_inspection_item_choices.CREATE_DATE AS FIIC_CREATE_DATE, 
                         dbo.inspect_final_inspection_item_choices.CREATE_TIME AS FIIC_CREATE_TIME, dbo.inspect_final_inspection_item_choices.CREATE_USER AS FIIC_CREATE_USER, 
                         dbo.inspect_final_inspection_header.FIH_INSPECTION_PLAN_ID, dbo.inspect_inspection_plan.IP_INSPECTION_TYPE_ID, dbo.inspect_inspection_type.IT_NAME, 
                         dbo.inspect_final_inspection_items.FII_FAIL_TEXT AS FIIC_NC_TEXT
FROM            dbo.inspect_final_inspection_items INNER JOIN
                         dbo.inspect_inspection_plan_Items ON dbo.inspect_final_inspection_items.FII_IPI_ID = dbo.inspect_inspection_plan_Items.IPI_ID INNER JOIN
                         dbo.inspect_final_inspection_header ON dbo.inspect_final_inspection_items.FII_INSPECTION_ID = dbo.inspect_final_inspection_header.FIH_INSPECTION_ID INNER JOIN
                         dbo.inspect_item_choices ON dbo.inspect_inspection_plan_Items.IPI_ITEM_ID = dbo.inspect_item_choices.IC_Item_ID INNER JOIN
                         dbo.inspect_master_items ON dbo.inspect_item_choices.IC_Item_ID = dbo.inspect_master_items.MI_ITEM_ID INNER JOIN
                         dbo.inspect_master_choices ON dbo.inspect_item_choices.IC_Choice_ID = dbo.inspect_master_choices.MC_CHOICE_ID INNER JOIN
                         dbo.inspect_model_floorplans ON dbo.inspect_final_inspection_header.FIH_FLOORPLAN_ID = dbo.inspect_model_floorplans.MF_FLOORPLAN_ID INNER JOIN
                         dbo.inspect_master_models ON dbo.inspect_model_floorplans.MF_MODEL_ID = dbo.inspect_master_models.MM_MODEL_ID INNER JOIN
                         dbo.inspect_master_zones ON dbo.inspect_final_inspection_items.FII_ZONE_ID = dbo.inspect_master_zones.MZ_ZONE_ID INNER JOIN
                         dbo.inspect_master_locations ON dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID = dbo.inspect_master_locations.ML_LOCATION_ID INNER JOIN
                         dbo.inspect_final_inspection_item_choices ON dbo.inspect_final_inspection_items.FII_RECORD_ID = dbo.inspect_final_inspection_item_choices.FIIC_FII_RECORD_ID AND 
                         dbo.inspect_item_choices.IC_Unique_ID = dbo.inspect_final_inspection_item_choices.FIIC_IC_UNIQUE_ID INNER JOIN
                         dbo.inspect_inspection_plan ON dbo.inspect_final_inspection_header.FIH_INSPECTION_PLAN_ID = dbo.inspect_inspection_plan.IP_INSPECTION_PLAN_ID INNER JOIN
                         dbo.inspect_inspection_type ON dbo.inspect_inspection_plan.IP_INSPECTION_TYPE_ID = dbo.inspect_inspection_type.IT_ID
ORDER BY dbo.inspect_final_inspection_header.FIH_INSPECTION_ID, dbo.inspect_master_locations.ML_SEQUENCE, dbo.inspect_master_zones.MZ_SEQUENCE, dbo.inspect_final_inspection_items.FII_SEQUENCE, 
                         dbo.inspect_item_choices.IC_Seq_No


' 
GO
/****** Object:  View [dbo].[inspect_fii_view_test_duration_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_fii_view_test_duration_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_fii_view_test_duration_vw]
AS
SELECT        FII_RECORD_ID, FII_TEST_START_DATE, FII_TEST_START_TIME, FII_TEST_START_TIME_SERVER, FII_TEST_END_TIME_SERVER, FII_REQUIRES_TEST, FII_TEST_RESULT_CODE, CONVERT(VARCHAR(8), 
                         GETDATE(), 108) AS CURR, DATEDIFF(MI, FII_TEST_START_TIME_SERVER, CONVERT(VARCHAR(8), GETDATE(), 108)) - 60 AS Running_Duration, DATEDIFF(MI, FII_TEST_START_TIME_SERVER, 
                         FII_TEST_END_TIME_SERVER) AS Completed_Duration
FROM            dbo.inspect_final_inspection_items
WHERE        (FII_REQUIRES_TEST <> ''N'')


' 
GO
/****** Object:  View [dbo].[inspect_fiia_main_saved_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_fiia_main_saved_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_fiia_main_saved_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_item_choices.IC_Unique_ID, dbo.inspect_master_locations.ML_SEQUENCE AS [Loc Seq], dbo.inspect_master_locations.ML_NAME, dbo.inspect_master_zones.MZ_SEQUENCE AS [Zone Seq], 
                         dbo.inspect_master_zones.MZ_NAME, dbo.inspect_item_choices.IC_Seq_No AS [Attrib Seq], dbo.inspect_final_inspection_items.FII_INSPECTION_ID, dbo.inspect_final_inspection_items.FII_INSPECTION_PLAN_ID, 
                         dbo.inspect_master_items.MI_TEXT, dbo.inspect_master_choices.MC_TEXT, dbo.inspect_master_items.MI_ITEM_ID, dbo.inspect_master_choices.MC_CHOICE_ID, dbo.inspect_final_inspection_items.FII_RECORD_ID, 
                         dbo.inspect_inspection_plan_items.IPI_ZONE_ID, dbo.inspect_final_inspection_items.FII_IPI_ID
FROM            dbo.inspect_master_choices INNER JOIN
                         dbo.inspect_item_choices ON dbo.inspect_master_choices.MC_CHOICE_ID = dbo.inspect_item_choices.IC_Choice_ID INNER JOIN
                         dbo.inspect_master_items INNER JOIN
                         dbo.inspect_inspection_plan_items INNER JOIN
                         dbo.inspect_final_inspection_items ON dbo.inspect_inspection_plan_items.IPI_ID = dbo.inspect_final_inspection_items.FII_IPI_ID INNER JOIN
                         dbo.inspect_master_zones ON dbo.inspect_inspection_plan_items.IPI_ZONE_ID = dbo.inspect_master_zones.MZ_ZONE_ID INNER JOIN
                         dbo.inspect_master_locations ON dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID = dbo.inspect_master_locations.ML_LOCATION_ID ON 
                         dbo.inspect_master_items.MI_ITEM_ID = dbo.inspect_inspection_plan_items.IPI_ITEM_ID ON dbo.inspect_item_choices.IC_Item_ID = dbo.inspect_master_items.MI_ITEM_ID
ORDER BY [Loc Seq], [Zone Seq], [Attrib Seq]


' 
GO
/****** Object:  View [dbo].[inspect_fiia_main_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_fiia_main_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_fiia_main_vw]
AS
SELECT     TOP (100) PERCENT dbo.inspect_item_choices.IC_Unique_ID, dbo.inspect_item_choices.IC_Seq_No AS [Attrib Seq], dbo.inspect_final_inspection_items.FII_INSPECTION_ID, 
                      dbo.inspect_final_inspection_items.FII_INSPECTION_PLAN_ID, dbo.inspect_master_items.MI_TEXT, dbo.inspect_master_choices.MC_TEXT, dbo.inspect_master_items.MI_ITEM_ID, 
                      dbo.inspect_master_choices.MC_CHOICE_ID, dbo.inspect_final_inspection_items.FII_RECORD_ID, dbo.inspect_final_inspection_items.FII_IPI_ID
FROM         dbo.inspect_final_inspection_items INNER JOIN
                      dbo.inspect_master_items INNER JOIN
                      dbo.inspect_master_choices INNER JOIN
                      dbo.inspect_item_choices ON dbo.inspect_master_choices.MC_CHOICE_ID = dbo.inspect_item_choices.IC_Choice_ID ON 
                      dbo.inspect_master_items.MI_ITEM_ID = dbo.inspect_item_choices.IC_Item_ID ON dbo.inspect_final_inspection_items.FII_ITEM_ID = dbo.inspect_master_items.MI_ITEM_ID
ORDER BY [Attrib Seq]


' 
GO
/****** Object:  View [dbo].[inspect_fiic_count_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_fiic_count_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_fiic_count_vw]
AS
SELECT        FIIC_FII_RECORD_ID, COUNT(*) AS Expr1
FROM            dbo.inspect_final_inspection_item_choices
GROUP BY FIIC_FII_RECORD_ID


' 
GO
/****** Object:  View [dbo].[inspect_final_inspection_dashboard_nc_by_location_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_final_inspection_dashboard_nc_by_location_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_final_inspection_dashboard_nc_by_location_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_final_inspection_header.FIH_INSPECTION_ID AS INSP_ID, dbo.inspect_final_inspection_header.FIH_STATUS_CODE AS HEADER_STATUS, 
                         dbo.inspect_final_inspection_header.FIH_VIN_NO AS VIN_NO, dbo.inspect_final_inspection_header.FIH_ORDER_NO AS ORDER_NO, dbo.inspect_master_locations.ML_NAME AS LOCATION, 
                         dbo.inspect_final_inspection_items.FII_HAS_EVER_FAILED AS EVER_FAILED, COUNT(*) AS COUNT
FROM            dbo.inspect_final_inspection_items INNER JOIN
                         dbo.inspect_final_inspection_header ON dbo.inspect_final_inspection_items.FII_INSPECTION_ID = dbo.inspect_final_inspection_header.FIH_INSPECTION_ID INNER JOIN
                         dbo.inspect_master_locations ON dbo.inspect_final_inspection_items.FII_LOCATION_ID = dbo.inspect_master_locations.ML_LOCATION_ID
GROUP BY dbo.inspect_final_inspection_header.FIH_INSPECTION_ID, dbo.inspect_final_inspection_header.FIH_STATUS_CODE, dbo.inspect_final_inspection_header.FIH_VIN_NO, dbo.inspect_final_inspection_header.FIH_ORDER_NO, 
                         dbo.inspect_final_inspection_items.FII_HAS_EVER_FAILED, dbo.inspect_master_locations.ML_NAME
HAVING        (dbo.inspect_final_inspection_header.FIH_STATUS_CODE = ''R'')
ORDER BY EVER_FAILED


' 
GO
/****** Object:  View [dbo].[inspect_ipi_view_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_ipi_view_vw]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[inspect_ipi_view_vw]
AS
SELECT        dbo.inspect_inspection_plan_items.IPI_INSPECTION_PLAN_ID, 
              dbo.inspect_inspection_plan_items.IPI_ITEM_ID, 
			  dbo.inspect_inspection_plan_items.IPI_SEQUENCE, 
			  dbo.inspect_inspection_plan_items.IPI_FEATURE_ID,
			  dbo.inspect_inspection_plan_items.IPI_ZONE_ID, 
              dbo.inspect_master_zones.MZ_ZONE_LOCATION_ID, 
			  dbo.inspect_inspection_plan_items.IPI_ID, 
			  dbo.inspect_master_items.MI_DEPARTMENT_ID, 
			  dbo.inspect_master_items.MI_TEST_CODE, 
			  dbo.inspect_master_items.MI_TEST_INSTRUCTION, 
              dbo.inspect_master_items.MI_TEST_EXPECTED_RESULT, 
			  dbo.inspect_master_items.MI_TEST_DURATION, 
			  dbo.inspect_master_items.MI_RESULT_TYPE
FROM            dbo.inspect_inspection_plan_items INNER JOIN
                dbo.inspect_master_zones ON dbo.inspect_inspection_plan_items.IPI_ZONE_ID = dbo.inspect_master_zones.MZ_ZONE_ID INNER JOIN
                dbo.inspect_master_items ON dbo.inspect_inspection_plan_items.IPI_ITEM_ID = dbo.inspect_master_items.MI_ITEM_ID




' 
GO
/****** Object:  View [dbo].[inspect_mi_no_attribute_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_mi_no_attribute_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_mi_no_attribute_vw]
AS
SELECT        TOP (100) PERCENT dbo.inspect_master_items.MI_ITEM_ID, dbo.inspect_master_items.MI_NAME, dbo.inspect_master_items.COMPANY_CODE, dbo.inspect_master_items.CREATE_DATE, dbo.inspect_master_items.CREATE_TIME, 
                         dbo.inspect_master_items.CREATE_USER, dbo.inspect_master_items.MI_TEST_CODE
FROM            dbo.inspect_master_items LEFT OUTER JOIN
                         dbo.inspect_item_choices ON dbo.inspect_master_items.MI_ITEM_ID = dbo.inspect_item_choices.IC_Item_ID
WHERE        (dbo.inspect_item_choices.IC_Item_ID IS NULL)
ORDER BY dbo.inspect_master_items.MI_NAME


' 
GO
/****** Object:  View [dbo].[inspect_mi_no_inspection_plan_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_mi_no_inspection_plan_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_mi_no_inspection_plan_vw]
AS
SELECT        dbo.inspect_master_items.MI_NAME, dbo.inspect_master_items.COMPANY_CODE, dbo.inspect_master_items.CREATE_DATE, dbo.inspect_master_items.CREATE_TIME, dbo.inspect_master_items.CREATE_USER, 
                         dbo.inspect_master_items.MI_ITEM_ID, dbo.inspect_master_items.MI_TEXT
FROM            dbo.inspect_inspection_plan_items RIGHT OUTER JOIN
                         dbo.inspect_master_items ON dbo.inspect_inspection_plan_items.IPI_ITEM_ID = dbo.inspect_master_items.MI_ITEM_ID
WHERE        (dbo.inspect_inspection_plan_items.IPI_ITEM_ID IS NULL) AND (dbo.inspect_master_items.MI_USAGE_CLASS = N''I'' OR
                         dbo.inspect_master_items.MI_USAGE_CLASS = N''B'')


' 
GO
/****** Object:  View [dbo].[inspect_troubleshoot_count_header_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_troubleshoot_count_header_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_troubleshoot_count_header_vw]
AS
SELECT        TOP (100) PERCENT FIH_ORDER_NO, FIH_INSPECTION_ID, FIH_VIN_NO, FIH_FLOORPLAN_ID, CREATE_DATE, FIH_COUNT_OPEN_ITEMS, FIH_COUNT_FAILED_ITEMS, FIH_COUNT_PASSED_ITEMS, 
                         FIH_COUNT_DISP_ITEMS, FIH_COUNT_NA_ITEMS, FIH_COUNT_TOTAL_ITEMS, FIH_COUNT_EVER_FAILED_ITEMS
FROM            dbo.inspect_final_inspection_header
WHERE        (FIH_COUNT_TOTAL_ITEMS IS NOT NULL)
ORDER BY FIH_ORDER_NO, FIH_INSPECTION_ID


' 
GO
/****** Object:  View [dbo].[inspect_view_orphan_fiic_vw]    Script Date: 2/21/2019 5:47:19 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[inspect_view_orphan_fiic_vw]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[inspect_view_orphan_fiic_vw]
AS
SELECT        dbo.inspect_final_inspection_item_choices.CREATE_DATE, dbo.inspect_final_inspection_item_choices.CREATE_TIME, dbo.inspect_final_inspection_item_choices.CREATE_USER, 
                         dbo.inspect_final_inspection_item_choices.FIIC_UNIQUE_ID, dbo.inspect_final_inspection_item_choices.FIIC_IC_UNIQUE_ID, dbo.inspect_final_inspection_item_choices.FIIC_FII_RECORD_ID, 
                         dbo.inspect_final_inspection_item_choices.COMPANY_CODE, dbo.inspect_final_inspection_item_choices.FIIC_INSPECTION_ID
FROM            dbo.inspect_final_inspection_item_choices LEFT OUTER JOIN
                         dbo.inspect_final_inspection_items ON dbo.inspect_final_inspection_item_choices.FIIC_FII_RECORD_ID = dbo.inspect_final_inspection_items.FII_RECORD_ID
WHERE        (dbo.inspect_final_inspection_items.FII_RECORD_ID IS NULL)


' 
GO

/****** Object:  StoredProcedure [dbo].[sp_inspect_create_daily_audit]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_create_daily_audit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_create_daily_audit] 

	-- Add the parameters for the stored procedure here>

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here

	INSERT
	INTO
	inspect_audit_header
	(
	COMPANY_CODE,
	MAH_AUDIT_DATE
	)
	VALUES
	(
	''AST'',
	CONVERT([date],getdate())
	)
	

	-- insert audit items
	INSERT
	INTO
	inspect_audit_items
	(
	COMPANY_CODE,
	MAI_AUDIT_ID,
	MAI_DEPARTMENT_ID,
	MAI_ITEM_ID,
	MAI_NBR_VEHICLES,
	CREATE_USER,
	MAI_MAP_AUDIT_FREQ_CODE,
	MAI_MAP_RECORD_ID
	)
	SELECT 	''AST'',
	SCOPE_IDENTITY(),
	MAP_DEPARTMENT_ID,
	MAP_ITEM_ID,
	MAP_NBR_VEHICLES,
	''System Process'',
	MAP_AUDIT_FREQ_CODE,
	MAP_RECORD_ID
	From
	inspect_audit_plan
	Where
	COMPANY_CODE = ''AST''
	AND MAP_AUDIT_FREQ_CODE = ''D''
End


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_cvpl_item_note_insert]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_cvpl_item_note_insert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_inspect_cvpl_item_note_insert]
	@p_item_id int
	,@p_created_by nvarchar(80)
	,@p_note_text nvarchar(4000)
	,@p_errors nvarchar(4000) output
AS
BEGIN

	SET NOCOUNT ON;

	declare @w_errors nvarchar(4000) = ''''

	IF ((@p_created_by is null) or (ltrim(rtrim(@p_created_by)) = '''')) BEGIN
		set @w_errors = @w_errors + ''<Message type=''''error''''><Text>Created By: Value is required.</Text></Message>'';
	END

	IF ((@p_note_text is null) or (ltrim(rtrim(@p_note_text)) = '''')) BEGIN
		set @w_errors = @w_errors + ''<Message type=''''error''''><Text>Note: Value is required.</Text></Message>'';
	END

	if (@w_errors = '''') begin 

		INSERT INTO [dbo].[inspect_cvpl_item_note]
			   ([item_id]
			   ,[note_text]
			   ,[note_created]
			   ,[note_created_by])
		 VALUES
			   (@p_item_id
			   ,@p_note_text
			   ,current_timestamp
			   ,@p_created_by);
		
		set @p_errors = null;				
	end else begin 
		set @p_errors = ''<Response>'' + @w_errors + ''</Response>'';
	end 

END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_cvpl_load_final_inspection_items]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_cvpl_load_final_inspection_items]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

CREATE PROCEDURE [dbo].[sp_inspect_cvpl_load_final_inspection_items] 
      (
      @p_FIH_INSPECTION_ID int
     ,@p_FIH_INSPECTION_PLAN_ID int
     ,@p_IP_LOCATION_ID int
     ,@p_VFI_COMPANY_CODE nvarchar(10)
     ,@p_client_date date
	 ,@p_client_time time(7)
	 ,@p_user nvarchar(20)
	 ,@p_errors nvarchar(4000) output
      )

AS 
BEGIN

DECLARE
      @w_errors varchar(2048) = '''',
      @w_key integer = 0;

INSERT INTO inspect_final_inspection_items (
           [FII_INSPECTION_ID]
           ,[FII_INSPECTION_PLAN_ID]
           ,[FII_ITEM_ID]
		   ,[FII_DEPT_ID]
		   ,[FII_FEATURE_ID]
           ,[FII_ZONE_ID]
           ,[FII_LOCATION_ID]
           ,[FII_SEQUENCE]
           ,[FII_REQUIRES_TEST]
           ,[FII_RESULT_CODE]
           ,[FII_HAS_EVER_FAILED]
           ,[FII_STATUS_CODE]
           ,[FII_FAIL_PIC]
           ,[FII_FAIL_TEXT]
           ,[COMPANY_CODE]
           ,[CREATE_DATE]
           ,[CREATE_TIME]
           ,[CREATE_USER]
           ,[LAST_UPDATE_DATE]
           ,[LAST_UPDATE_TIME]
           ,[LAST_UPDATE_USER]
           ,[FII_IPI_ID]
           ,[FII_TEST_RESULT_CODE]
           ,[FII_RESULT_TYPE]
) VALUES (
	@p_FIH_INSPECTION_ID,
	@p_FIH_INSPECTION_PLAN_ID,
	'''',
	'''',
	'''',
	'''',
	@p_IP_LOCATION_ID,
	''999'',
	''N'',
	''F'',
	''Y'',
	''R'',
	'''',
	'''',
	@p_VFI_COMPANY_CODE,
	@p_client_date,
	@p_client_time,
	@p_user,
	@p_client_date,
	@p_client_time,
	@p_user,
	'''',
	''O'',
	''B'');

SET @w_key = SCOPE_IDENTITY();

set @p_errors = 
''<Response><SetSessionProperty><SessionProperty name=''''S_FII_RECORD_ID''''><Value>'' + 
cast(@w_key as varchar(10)) + 
''</Value></SessionProperty></SetSessionProperty></Response>'';

END




' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_cvpl_load_inspection_plans_daily]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_cvpl_load_inspection_plans_daily]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_inspect_cvpl_load_inspection_plans_daily]

AS
BEGIN

	 	  			INSERT INTO inspect_final_inspection_header
				(
				[FIH_FLOORPLAN_ID],
				[FIH_MODEL_ID],
				[FIH_ORDER_NO],
				[FIH_INSPECTION_PLAN_ID],
				[CREATE_USER],
				[COMPANY_CODE],
				[FIH_VIN_NO],
				[FIH_STATUS_CODE],
				[CREATE_DATE],
				[CREATE_TIME]
				)
				SELECT [MF_FLOORPLAN_ID]
      ,[MF_MODEL_ID]
      ,[ORD_NO]
      ,[MFIT_INSPECTION_PLAN_ID]
      ,[CREATE_USER]
      ,[COMPANY_CODE]
      ,[VIN_NO]
      ,[STATUS_CODE]
      ,[CREATE_DATE]
      ,[CREATE_TIME]
    FROM [dbo].[inspect_vw20_order_model] 
  WHERE COUNTER = 0

END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_cvpl_release_master_inspection]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_cvpl_release_master_inspection]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE  PROCEDURE [dbo].[sp_inspect_cvpl_release_master_inspection] 
      (
      @p_FIH_INSPECTION_ID int
     ,@p_FIH_ORDER_NO nvarchar(50)
     ,@p_FIH_MODEL_ID int
     ,@p_VFI_COMPANY_CODE nvarchar(10)
     ,@p_FIH_MASTER_INSPECTION_PLAN_ID int
 	 ,@p_user nvarchar(20)
	 ,@p_client_date date
	 ,@p_client_time time(7)
     ,@p_errors nvarchar(4000) output
      )

AS 
BEGIN

	DECLARE
      @w_errors varchar(2048) = '''',
      @w_key integer = 0,
      @name varchar(10)
	SET @w_key = (SELECT COUNT(*)   
	 FROM dbo.inspect_final_inspection_header
	WHERE
	FIH_ORDER_NO = @p_FIH_ORDER_NO AND 
	FIH_MODEL_ID = @p_FIH_MODEL_ID AND 
	FIH_INSPECTION_PLAN_ID <> @p_FIH_MASTER_INSPECTION_PLAN_ID AND
	FIH_STATUS_CODE <> ''R'' )
  
		IF @w_key > 0 BEGIN
 
				DECLARE db_cursor CURSOR FOR  
				SELECT CAST(FIH_INSPECTION_ID AS varchar(10))   
					FROM dbo.inspect_final_inspection_header
				WHERE
				FIH_ORDER_NO = @p_FIH_ORDER_NO AND 
				FIH_MODEL_ID = @p_FIH_MODEL_ID AND 
				FIH_INSPECTION_PLAN_ID <> @p_FIH_MASTER_INSPECTION_PLAN_ID AND
				FIH_STATUS_CODE <> ''R'' 
 
			OPEN db_cursor   
			FETCH NEXT FROM db_cursor INTO @name   

			WHILE @@FETCH_STATUS = 0   
			BEGIN   
					SET @w_errors = ( @w_errors + @name + '' '' ) 
       
					FETCH NEXT FROM db_cursor INTO @name   
			END   

			CLOSE db_cursor   
			DEALLOCATE db_cursor
  
			set @p_errors = ''<Response><Message type=''''error''''><Text>'' + cast(@w_key as varchar(10)) + '' open Inspections found. Inspection number(s): '' 
				+ @w_errors + '' must be released before Full Unit can be released.</Text></Message></Response>'';
		END
		ELSE BEGIN
			UPDATE inspect_final_inspection_header
			SET 
			FIH_DATE_RELEASED = @p_client_date,
			FIH_TIME_RELEASED = @p_client_time,
			FIH_USER_RELEASED = @p_user,
			FIH_STATUS_CODE = ''R'',
			FIH_RELEASE_ERROR = Null
			WHERE FIH_INSPECTION_ID = @p_FIH_INSPECTION_ID
			/*                                       */
			/* Write to the event journal */
			/*                                       */
			INSERT INTO inspect_final_inspection_event_journal
			(FIEJ_INSPECTION_ID,
			FIEJ_FII_RECORD_ID,
			COMPANY_CODE,
			FIEJ_EVENT_CODE,
			FIEJ_EVENT_DATE,
			FIEJ_EVENT_TIME,
			FIEJ_EVENT_USER
			)
			VALUES
			(
			@p_FIH_INSPECTION_ID,
			0,
			@p_VFI_COMPANY_CODE,
			/* Event Code 950 means Final Inspection Released  */
			''950'',
			@p_client_date,
			@p_client_time,
			@p_user
			)
			;

			set @p_errors = ''<Response><SetSessionProperty><SessionProperty name=''''S_FII_INSPECTION_ID''''><Value>'' + 
			cast(@p_FIH_INSPECTION_ID as varchar(10)) + ''</Value></SessionProperty></SetSessionProperty></Response>''
         END
END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_defect_notifications]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_defect_notifications]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'




CREATE PROCEDURE [dbo].[sp_inspect_defect_notifications] 
      (
      @p_FIIC_INSPECTION_ID int
  --   ,@p_FIH_INSPECTION_PLAN_ID int
  --   ,@p_IP_LOCATION_ID int
  --   ,@p_VFI_COMPANY_CODE nvarchar(10)
  --   ,@p_client_date date
	 --,@p_client_time time(7)
	 --,@p_user nvarchar(20)
	 ,@p_errors nvarchar(4000) output
      )

AS 
BEGIN

DECLARE
      @w_errors varchar(2048) = '''',
	  @w_FIH_ORDER_NO VARCHAR(50),
	  @w_IP_NAME VARCHAR(50),
	  @w_DF_COUNT int,
	  @w_DF_DEPT_COUNT int,
	  @w_DF_TOTAL_COUNT int,
	  @w_FII_DEPT_ID INT,
	  @w_DEFECTS VARCHAR(4000) = '''',
	  @w_DEFECTS2 VARCHAR(4000) = '''',
	  @w_MI_NAME VARCHAR(50),
	  @w_MC_NAME VARCHAR(50),
	  @w_ML_NAME VARCHAR(50),
	  @w_MZ_NAME VARCHAR(50),
	  @w_MF_NAME VARCHAR(50),
      @w_key integer = 0;

SELECT  @w_FIH_ORDER_NO = FIH_ORDER_NO
       ,@w_IP_NAME = [IP_NAME]
      --,[MI_NAME]
      --,[MC_NAME]
      --,[FII_DEPT_ID]
      ,@w_DF_TOTAL_COUNT = SUM(DF_COUNT)
  FROM  [inspect_nofication_defect_sum_vw]
  WHERE [FIIC_INSPECTION_ID] = @p_FIIC_INSPECTION_ID
  GROUP BY [FIH_ORDER_NO]
          ,[IP_NAME]
  -- CURSOR FOR EACH DEPARTMENT
			DECLARE db_cursor CURSOR FOR 
			SELECT [FII_DEPT_ID], SUM(DF_COUNT)
				FROM [dbo].[inspect_nofication_defect_sum_vw]
			    WHERE [FIIC_INSPECTION_ID] = @p_FIIC_INSPECTION_ID
				GROUP BY [FII_DEPT_ID]
			
			OPEN db_cursor   
			FETCH NEXT FROM db_cursor INTO @w_FII_DEPT_ID, @w_DF_DEPT_COUNT

			WHILE @@FETCH_STATUS = 0   
				BEGIN
				-- build message body with defects 
						DECLARE db_cursor2 CURSOR FOR 
						SELECT [ML_NAME], [MZ_NAME], [MF_NAME], [MI_NAME], [MC_NAME], SUM(DF_COUNT)
							FROM [dbo].[inspect_nofication_defect_sum_vw]
							WHERE [FIIC_INSPECTION_ID] = @p_FIIC_INSPECTION_ID 
							AND [FII_DEPT_ID] = @w_FII_DEPT_ID
							GROUP BY ML_NAME, MZ_NAME, MF_NAME, [MI_NAME], [MC_NAME]
			
						OPEN db_cursor2   
						FETCH NEXT FROM db_cursor2 INTO @w_ML_NAME, @w_MZ_NAME, @w_MF_NAME, @w_MI_NAME, @w_MC_NAME, @w_DF_COUNT

						WHILE @@FETCH_STATUS = 0   
							BEGIN 
--							SET @w_DEFECTS = @w_DEFECTS +
--							 '' Item: ''+ @w_MI_NAME+ '' - ''  + CAST(@w_DF_COUNT as varchar(3)) + '' ''  + @w_MC_NAME +'' defect(s) ''
--                          SET @w_DEFECTS = @w_DEFECTS +
--      					 ''   Location: ''+ @w_ML_NAME + ''   Zone: '' + @w_MZ_NAME + ''   Feature: '' + @w_MF_NAME + 
-- 							 ''   Item: ''+ @w_MI_NAME + ''   Defect: '' + @w_MC_NAME
							 SET @w_DEFECTS = @w_DEFECTS +
							 @w_ML_NAME + ''  /  '' + @w_MZ_NAME + ''  /  '' + @w_MF_NAME + ''  /  ''+ @w_MI_NAME + ''  /  '' + @w_MC_NAME + CHAR(10)
							 SET @w_DEFECTS2 = @w_DEFECTS2 +
							 @w_ML_NAME + ''  /  '' + @w_MZ_NAME + ''  /  '' + @w_MF_NAME + ''  /  ''+ @w_MI_NAME + ''  /  '' + @w_MC_NAME + ''<br />''
			  				FETCH NEXT FROM db_cursor2 INTO @w_ML_NAME, @w_MZ_NAME, @w_MF_NAME, @w_MI_NAME, @w_MC_NAME,@w_DF_COUNT  
							END   

						CLOSE db_cursor2   
						DEALLOCATE db_cursor2
					-- end message body with defects
						INSERT INTO catavolt_notification (
									[notification_type]
								   ,[notification_groupid]
								   ,[notification_title]
								   ,[notification_body]
								   ,[notification_body_formatted]
						)
						VALUES (
							''DEFECT''
							,cast(@w_FII_DEPT_ID AS VARCHAR(10))
							,@w_IP_NAME + '' found ''+ CAST(@w_DF_DEPT_COUNT as varchar(3)) +'' defects on '' + @w_FIH_ORDER_NO  
							,@w_DEFECTS
							,@w_DEFECTS2
							);
				SET @w_DEFECTS = ''''
				SET @w_DEFECTS2 = ''''

				  FETCH NEXT FROM db_cursor INTO @w_FII_DEPT_ID, @w_DF_DEPT_COUNT  
				END   

			CLOSE db_cursor   
			DEALLOCATE db_cursor



--set @p_errors = 
--''<Response><SetSessionProperty><SessionProperty name=''''S_FII_RECORD_ID''''><Value>'' + 
--cast(@w_key as varchar(10)) + 
--''</Value></SessionProperty></SetSessionProperty></Response>'';

END







' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_defect_notifications2]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_defect_notifications2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



CREATE PROCEDURE [dbo].[sp_inspect_defect_notifications2] 
      (
      @p_FIIC_INSPECTION_ID int
  --   ,@p_FIH_INSPECTION_PLAN_ID int
  --   ,@p_IP_LOCATION_ID int
  --   ,@p_VFI_COMPANY_CODE nvarchar(10)
  --   ,@p_client_date date
	 --,@p_client_time time(7)
	 --,@p_user nvarchar(20)
	 ,@p_errors nvarchar(4000) output
      )

AS 
BEGIN

DECLARE
      @w_errors varchar(2048) = '''',
	  @w_FIH_ORDER_NO VARCHAR(50),
	  @w_IP_NAME VARCHAR(50),
	  @w_DF_COUNT int,
	  @w_DF_DEPT_COUNT int,
	  @w_DF_TOTAL_COUNT int,
	  @w_FII_DEPT_ID INT,
	  @w_DEFECTS VARCHAR(400) = '''',
	  @w_MI_NAME VARCHAR(50),
	  @w_MC_NAME VARCHAR(50),
      @w_key integer = 0;
IF (SELECT FIH_NOTIFIED FROM inspect_final_inspection_header WHERE FIH_INSPECTION_ID = @p_FIIC_INSPECTION_ID) = 0
BEGIN

  SELECT  @w_FIH_ORDER_NO = FIH_ORDER_NO
           ,@w_IP_NAME = [IP_NAME]
      --,[MI_NAME]
      --,[MC_NAME]
      --,[FII_DEPT_ID]
      ,@w_DF_TOTAL_COUNT = SUM(DF_COUNT)
  FROM  [inspect_nofication_defect_sum_vw]

  WHERE [FIIC_INSPECTION_ID] = @p_FIIC_INSPECTION_ID
    GROUP BY [FIH_ORDER_NO],[IP_NAME]
  -- CURSOR FOR EACH DEPARTMENT
			DECLARE db_cursor CURSOR FOR 
			SELECT [FII_DEPT_ID], SUM(DF_COUNT)
				FROM [dbo].[inspect_nofication_defect_sum_vw]
			    WHERE [FIIC_INSPECTION_ID] = @p_FIIC_INSPECTION_ID
				GROUP BY [FII_DEPT_ID]
			
			OPEN db_cursor   
			FETCH NEXT FROM db_cursor INTO @w_FII_DEPT_ID, @w_DF_DEPT_COUNT

			WHILE @@FETCH_STATUS = 0   
				BEGIN
				-- build message body with defects 
						DECLARE db_cursor2 CURSOR FOR 
						SELECT [MI_NAME],[MC_NAME],SUM(DF_COUNT)
							FROM [dbo].[inspect_nofication_defect_sum_vw]
							
							WHERE [FIIC_INSPECTION_ID] = @p_FIIC_INSPECTION_ID 
							AND [FII_DEPT_ID] = @w_FII_DEPT_ID
							GROUP BY [MI_NAME],[MC_NAME]
			
						OPEN db_cursor2   
						FETCH NEXT FROM db_cursor2 INTO @w_MI_NAME, @w_MC_NAME,@w_DF_COUNT

						WHILE @@FETCH_STATUS = 0   
							BEGIN 
							SET @w_DEFECTS = @w_DEFECTS +
							 '' Item: ''+ @w_MI_NAME+ '' - ''  + CAST(@w_DF_COUNT as varchar(3)) + '' ''  + @w_MC_NAME +'' defect(s) ''
			  				FETCH NEXT FROM db_cursor2 INTO @w_MI_NAME, @w_MC_NAME,@w_DF_COUNT  
							END   

						CLOSE db_cursor2   
						DEALLOCATE db_cursor2
					-- end message body with defects
						INSERT INTO catavolt_notification (
									[notification_type]
								   ,[notification_groupid]
								   ,[notification_title]
								   ,[notification_body]
						)
						VALUES (
							''DEFECT''
							,cast(@w_FII_DEPT_ID AS VARCHAR(10))
							,@w_IP_NAME + '' found ''+ CAST(@w_DF_DEPT_COUNT as varchar(3)) +'' defects on '' + @w_FIH_ORDER_NO  
							, @w_DEFECTS
							);
				SET @w_DEFECTS = ''''

				  FETCH NEXT FROM db_cursor INTO @w_FII_DEPT_ID, @w_DF_DEPT_COUNT  
				END   

			CLOSE db_cursor   
			DEALLOCATE db_cursor
			UPDATE VFI_Final_Inspection_Header SET  FIH_NOTIFIED = 1 WHERE FIH_INSPECTION_ID = @p_FIIC_INSPECTION_ID;
END

--set @p_errors = 
--''<Response><SetSessionProperty><SessionProperty name=''''S_FII_RECORD_ID''''><Value>'' + 
--cast(@w_key as varchar(10)) + 
--''</Value></SessionProperty></SetSessionProperty></Response>'';

END





' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_delete_orphaned_fii]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_delete_orphaned_fii]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- Batch submitted through debugger: SQLQuery9.sql|7|0|C:\Users\teliasen\AppData\Local\Temp\6\~vs2163.sql

-- =============================================
-- Author: T. Eliasen
-- Create date: June 23, 2016
-- Description:	Delete Orphaned records from Final Inspection Item Choices
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_delete_orphaned_fii]

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

Delete from inspect_final_inspection_items
Where
FII_INSPECTION_ID not in (Select FIH_INSPECTION_ID from inspect_final_inspection_header)

END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_delete_orphaned_fiic]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_delete_orphaned_fiic]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author: T. Eliasen
-- Create date: June 23, 2016
-- Description:	Delete Orphaned records from Final Inspection Item Choices
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_delete_orphaned_fiic]

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

Delete from inspect_final_inspection_item_choices
Where
FIIC_FII_RECORD_ID not in (Select FII_RECORD_ID from inspect_final_inspection_items)

END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_insert_adhoc_defect_item]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_insert_adhoc_defect_item]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'




CREATE PROCEDURE [dbo].[sp_inspect_insert_adhoc_defect_item] 
      (
      @p_FIH_INSPECTION_ID int
     ,@p_FIH_INSPECTION_PLAN_ID int
  	 ,@p_FII_ITEM_ID int
	 ,@p_FII_DEPT_ID int
	 ,@p_FII_FEATURE_ID int
	 ,@p_FII_ZONE_ID int
	 ,@p_FII_LOCATION_ID int
     ,@p_VFI_COMPANY_CODE nvarchar(3)
	 ,@p_user nvarchar(20)
     ,@p_client_date date
	 ,@p_client_time time(7)
	 ,@p_errors nvarchar(4000) output
      )

AS 
BEGIN

DECLARE
      @w_errors varchar(2048) = '''',
      @w_key integer = 0;

/*                                       */
/* ===================== Insert Ad-hoc Defect Item ========================== */
/*                                       */
INSERT INTO inspect_final_inspection_items 
(
            [FII_INSPECTION_ID]
           ,[FII_INSPECTION_PLAN_ID]
           ,[FII_ITEM_ID]
           ,[FII_DEPT_ID]
           ,[FII_FEATURE_ID]
           ,[FII_ZONE_ID]
           ,[FII_LOCATION_ID]
           ,[FII_SEQUENCE]
           ,[FII_REQUIRES_TEST]
           ,[FII_RESULT_CODE]
           ,[FII_HAS_EVER_FAILED]
           ,[FII_STATUS_CODE]
           ,[FII_FAIL_PIC]
           ,[FII_FAIL_TEXT]
           ,[COMPANY_CODE]
           ,[CREATE_USER]
           ,[CREATE_DATE]
           ,[CREATE_TIME]
           ,[FII_IPI_ID]
           ,[FII_TEST_RESULT_CODE]
           ,[FII_RESULT_TYPE]
) 
VALUES 
(
	@p_FIH_INSPECTION_ID,
	@p_FIH_INSPECTION_PLAN_ID,
	@p_FII_ITEM_ID,
	@p_FII_DEPT_ID,
	@p_FII_FEATURE_ID,
	@p_FII_ZONE_ID,
	@p_FII_LOCATION_ID,
	''999'',
	''N'',
	''F'',
	''Y'',
	''R'',
	'''',
	'''',
	@p_VFI_COMPANY_CODE,
	@p_user,
	@p_client_date,
	@p_client_time,
    (SELECT IPI_ID 
    FROM inspect_inspection_plan_items 
    WHERE IPI_ITEM_ID = @p_FII_ITEM_ID
	AND  IPI_LOCATION_ID = @p_FII_LOCATION_ID
	AND   IPI_ZONE_ID = @p_FII_ZONE_ID
	AND   IPI_FEATURE_ID = @p_FII_FEATURE_ID
	AND   IPI_INSPECTION_PLAN_ID = 
    (SELECT IP_INSPECTION_PLAN_ID 
    FROM inspect_inspection_plan
    WHERE  IP_XREF_PLAN = ''Y'')),
	''O'',
	''B''
);

SET @w_key = SCOPE_IDENTITY();

set @p_errors = 
''<Response><SetSessionProperty><SessionProperty name=''''S_FII_RECORD_ID''''><Value>'' + 
cast(@w_key as varchar(10)) + 
''</Value></SessionProperty></SetSessionProperty></Response>'';

/*                                       */
/* =====================Write to Event Journal ========================== */
/*                                       */
INSERT INTO inspect_event_journal
(
     FIEJ_INSPECTION_ID,
     FIEJ_FII_RECORD_ID,
     COMPANY_CODE,
     FIEJ_EVENT_CODE,
     FIEJ_EVENT_DATE,
     FIEJ_EVENT_TIME,
     FIEJ_EVENT_USER
)
VALUES
(
     @p_FIH_INSPECTION_ID,
     @w_key,
     @p_VFI_COMPANY_CODE,
     /* Event Code 225 represents an ad-hoc defect that was created on the inspection plan */
     ''225'',
	 @p_client_date,
	 @p_client_time,
	 @p_user
);

END








' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_mai_assign_production_line_Daily]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_mai_assign_production_line_Daily]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[sp_inspect_mai_assign_production_line_Daily]
	-- Add the parameters for the stored procedure here

AS
BEGIN
	
	DECLARE @p_audit_id int,
			@p_audit_id_pl int,
	        @p_user nvarchar(10) = ''System Process'',
	        @p_audit_date date = CONVERT([date],getdate()),
			@p_Production_Line_Id_cr int,
			@p_found_items_PL varchar (1),
			@p_found_header_PL varchar (1),
			@w_COMPANY_CODE varchar(10) = ''AST''
	        
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Setup cursor to read production lines
DECLARE crsr CURSOR READ_ONLY FOR 
   SELECT 
   PL_PRODUCTION_LINE_ID
   FROM [dbo].[inspect_production_line]
   ORDER BY PL_PRODUCTION_LINE_ID;
--
OPEN crsr
--
FETCH NEXT FROM crsr INTO @p_Production_Line_Id_cr
--
WHILE @@FETCH_STATUS= 0  BEGIN
-- check for any items on today''s audit for this production line
IF Exists (select MAI_PRODUCTION_LINE from [dbo].[inspect_audit_items] where CREATE_DATE = @p_audit_date and MAI_PRODUCTION_LINE = @p_Production_Line_Id_cr)
   Begin
-- Now check for a header for today for this production line
        If Not Exists (select MAH_AUDIT_ID from [dbo].[inspect_audit_header] where MAH_AUDIT_DATE = @p_audit_date and MAH_PRODUCTION_LINE = @p_production_line_id_cr)
		Begin
--		Header does not exist for the Production line for today, then create one.		
--		Create Audit Header
			INSERT INTO inspect_audit_header
			(COMPANY_CODE,MAH_AUDIT_DATE,MAH_PRODUCTION_LINE)
			VALUES
			(@w_COMPANY_CODE,@p_audit_date,	@p_Production_Line_Id_cr);
	
			SET @p_audit_id_pl = SCOPE_IDENTITY();	
		End;
	End;

--Now...update all items selected for this production line; set the audit ID = the new header just created fro this production line
Update	inspect_audit_items
Set		MAI_AUDIT_ID = @p_audit_id_pl
where	MAI_PRODUCTION_LINE = @p_Production_Line_Id_cr
		and CREATE_DATE = @p_audit_date;

FETCH NEXT FROM crsr INTO @p_Production_Line_Id_cr

Close crsr
Deallocate crsr
	
END

End




' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_mai_delete audit header_no_pl_daily]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_mai_delete audit header_no_pl_daily]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[sp_inspect_mai_delete audit header_no_pl_daily]
	-- Add the parameters for the stored procedure here

AS
BEGIN
	
	DECLARE 
	        @p_audit_date date = CONVERT([date],getdate()),
			@w_COMPANY_CODE varchar(10) = ''AST''
	        
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

--Delete the header created today that has no production line tied to it.

Delete from [dbo].[inspect_audit_header]
Where
MAH_AUDIT_DATE = @p_audit_date
and COMPANY_CODE = ''AST''
and MAH_PRODUCTION_LINE is null

End



' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_mai_select_audit_items]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_mai_select_audit_items]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[sp_inspect_mai_select_audit_items] 
	@p_user nvarchar(10), 
	@p_audit_date date,
	@p_audit_id int,
	@p_errors nvarchar(2048) output
AS
BEGIN
--	SET @p_errors = ''test''
	DECLARE @w_audit_today_w int = 0,
	        @w_audit_today_m int = 0,
	        @p_list nvarchar(200) = '''',
	        @w_errors nvarchar(2000) = '''', 
			@p_MAI_AUDIT_ID int, 
            @p_MAI_ITEM_ID int,
            @p_MAI_DEPARTMENT_ID int;
IF (SELECT COUNT(*) FROM [dbo].[inspect_audit_items] WHERE MAI_AUDIT_ID = @p_audit_id) > 0 
BEGIN 
 SET @w_errors = @w_errors +
     ''<SessionProperty name=''''S_Message''''><Value>Items were already added to Audit#'' + CONVERT(VARCHAR,@p_audit_id) + '' </Value></SessionProperty>''	; 
 END 
ELSE
 BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_NEWID = NEWID();
	declare @w_countALL_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'')
	declare @w_countALL_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'')
	declare @w_countAUDIT_W int = 
	(SELECT COUNT(*) FROM [dbo].[AUD_Mfg_Audit_Plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))
	declare @w_countAUDIT_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))

-- DAILY ITEMS
INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID]
		   ,[MAI_MAP_AUDIT_FREQ_CODE])
		   SELECT       
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID], ''D''
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''D'' 
   ORDER BY MAP_AUDIT_NEWID;



 -- MONTHLY PROCESS	
	IF @w_countALL_M > 0 AND @w_countAUDIT_M = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''M'' 
			SET @w_audit_today_m = ROUND((@w_countALL_M/20)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_m = ROUND((@w_countALL_M/20)+0.5,0);
	

	DECLARE crM CURSOR READ_ONLY FOR 
   SELECT 
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID]
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID;
OPEN crM
FETCH NEXT FROM crM INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID
WHILE @@FETCH_STATUS= 0 AND @w_audit_today_m >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID], [MAI_MAP_AUDIT_FREQ_CODE])
			VALUES (@p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID,''M'');     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_m = (@w_audit_today_m - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) ;
  FETCH NEXT FROM crM INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID 
        END 
CLOSE	crM
DEALLOCATE crM 

	
-- WEEKLY PROCESS	
	IF @w_countALL_W > 0 AND @w_countAUDIT_W = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''W'' 
			SET @w_audit_today_w = ROUND((@w_countALL_W/5)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_w = ROUND((@w_countALL_W/5)+0.5,0);
	

DECLARE cr CURSOR READ_ONLY FOR 
   SELECT 
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID]
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID
OPEN cr
FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID
WHILE @@FETCH_STATUS= 0 AND @w_audit_today_w >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID], [MAI_MAP_AUDIT_FREQ_CODE])
			VALUES (@p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID,''W'');     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_w = (@w_audit_today_w - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) +''-'' + CONVERT(VARCHAR,@p_MAI_DEPARTMENT_ID) +'' '' ;
  FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID 
        END 
CLOSE	cr
DEALLOCATE cr 


        set @w_errors = @w_errors +
		        ''<SessionProperty name=''''S_Message''''><Value>'' + @p_list  +
                ''items added to weekely process</Value></SessionProperty>''	;
END

		set @p_errors = ''<Response><SetSessionProperty>'' + @w_errors + ''</SetSessionProperty></Response>''; 
		
		
		
END




' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_mai_select_audit_items_auto]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_mai_select_audit_items_auto]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Francisco Daffre Catavolt, Inc >
-- Create date: <August 30thMay 23, 2016>
-- Description:	<Select Items for Daily audit>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_mai_select_audit_items_auto] 

@p_errors nvarchar(2048) output
AS
BEGIN
--	SET @p_errors = ''test''
	DECLARE @p_audit_id int,
	        @p_user nvarchar(10) = ''System Process'',
	        @p_audit_date date = CONVERT([date],getdate()) ,
	        @w_audit_today_w int = 0,
	        @w_audit_today_m int = 0,
	        @p_list nvarchar(200) = ''Monthly:'',
	        @w_errors nvarchar(2000) = '''', 
			@p_MAI_AUDIT_ID int, 
            @p_MAI_ITEM_ID int,
            @p_MAI_DEPARTMENT_ID int,
			@w_COMPANY_CODE varchar(10) = ''AST'',
			@p_MAP_RECORD_ID int,
			@p_MAP_NBR_VEHICLES int,
			@p_MAP_PRODUCTION_LINE int
						;
-- Tim Eliasen Create Audit id Code
	INSERT
	INTO
	inspect_audit_header
	(
	COMPANY_CODE,
	MAH_AUDIT_DATE
	)
	VALUES
	(
	@w_COMPANY_CODE,
	@p_audit_date
	);
	
	SET @p_audit_id = SCOPE_IDENTITY();

IF (SELECT COUNT(*) FROM [dbo].[inspect_audit_items] WHERE MAI_AUDIT_ID = @p_audit_id) > 0 
BEGIN 
 SET @w_errors = @w_errors +
     ''<SessionProperty name=''''S_Message''''><Value>Items were already added to Audit#'' + CONVERT(VARCHAR,@p_audit_id) + '' Please select another Audit</Value></SessionProperty>''	; 
 END 
ELSE
 BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_NEWID = NEWID();
	declare @w_countALL_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'')
	declare @w_countALL_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'')
	declare @w_countAUDIT_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))
	declare @w_countAUDIT_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))

-- DAILY ITEMS
INSERT INTO [dbo].[inspect_audit_items]
           (COMPANY_CODE
		   ,[MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
		   ,MAI_NBR_VEHICLES
           ,[MAI_DEPARTMENT_ID]
		   ,[CREATE_USER]
		   ,[MAI_MAP_AUDIT_FREQ_CODE]
		   ,MAI_MAP_RECORD_ID
		   ,MAI_PRODUCTION_LINE)
		   SELECT       
    @w_COMPANY_CODE
   ,@p_audit_id
   ,[MAP_ITEM_ID]
   ,MAP_NBR_VEHICLES
   ,[MAP_DEPARTMENT_ID]
   , @p_user
   ,''D''
   ,MAP_RECORD_ID
   ,MAP_PRODUCTION_LINE 
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''D'' 
    ORDER BY MAP_AUDIT_NEWID;



 -- MONTHLY PROCESS	
	IF @w_countALL_M > 0 AND @w_countAUDIT_M = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''M'' 
			SET @w_audit_today_m = ROUND((@w_countALL_M/20)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_m = ROUND((@w_countALL_M/20)+0.5,0);
	

	DECLARE crM CURSOR READ_ONLY FOR 
   SELECT 
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,MAP_NBR_VEHICLES
   ,[MAP_DEPARTMENT_ID]
   ,MAP_RECORD_ID
   ,MAP_PRODUCTION_LINE
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID;
OPEN crM
FETCH NEXT FROM crM INTO @p_MAI_AUDIT_ID,@p_MAI_ITEM_ID,@p_MAP_NBR_VEHICLES, @p_MAI_DEPARTMENT_ID,@p_MAP_RECORD_ID,@p_MAP_PRODUCTION_LINE
WHILE @@FETCH_STATUS= 0 AND @w_audit_today_m >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           (COMPANY_CODE
		   ,[MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
		   ,MAI_NBR_VEHICLES
           ,[MAI_DEPARTMENT_ID]
		   ,[CREATE_USER]
		   ,[MAI_MAP_AUDIT_FREQ_CODE]
		   ,MAI_MAP_RECORD_ID
		   ,MAI_PRODUCTION_LINE)
			VALUES ( 
			@w_COMPANY_CODE
           ,@p_MAI_AUDIT_ID
		   ,@p_MAI_ITEM_ID
		   ,@p_MAP_NBR_VEHICLES
		   ,@p_MAI_DEPARTMENT_ID
		   ,@p_user
		   ,''M''
		   ,@p_MAP_RECORD_ID
		   ,@p_MAP_PRODUCTION_LINE);     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_m = (@w_audit_today_m - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) +''-'' + CONVERT(VARCHAR,@p_MAI_DEPARTMENT_ID) +'' , '' ;
  FETCH NEXT FROM crM INTO @p_MAI_AUDIT_ID,@p_MAI_ITEM_ID,@p_MAP_NBR_VEHICLES, @p_MAI_DEPARTMENT_ID,@p_MAP_RECORD_ID,@p_MAP_PRODUCTION_LINE
        END 
CLOSE	crM
DEALLOCATE crM 
SET @p_list = @p_list + '' Weekly: '';
	
-- WEEKLY PROCESS	
	IF @w_countALL_W > 0 AND @w_countAUDIT_W = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''W'' 
			SET @w_audit_today_w = ROUND((@w_countALL_W * .222)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_w = ROUND((@w_countALL_W * .222)+0.5,0);
	

DECLARE cr CURSOR READ_ONLY FOR 
   SELECT 
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,MAP_NBR_VEHICLES
   ,[MAP_DEPARTMENT_ID]
   ,MAP_RECORD_ID
   ,MAP_PRODUCTION_LINE
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID
OPEN cr
FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID,@p_MAI_ITEM_ID,@p_MAP_NBR_VEHICLES, @p_MAI_DEPARTMENT_ID,@p_MAP_RECORD_ID,@p_MAP_PRODUCTION_LINE
WHILE @@FETCH_STATUS= 0 AND @w_audit_today_w >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           (COMPANY_CODE
		   ,[MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
		   ,MAI_NBR_VEHICLES
           ,[MAI_DEPARTMENT_ID]
		   ,[CREATE_USER]
		   ,[MAI_MAP_AUDIT_FREQ_CODE]
		   ,MAI_MAP_RECORD_ID
		   ,MAI_PRODUCTION_LINE)
			VALUES ( 
			@w_COMPANY_CODE
           ,@p_MAI_AUDIT_ID
		   ,@p_MAI_ITEM_ID
		   ,@p_MAP_NBR_VEHICLES
		   ,@p_MAI_DEPARTMENT_ID
		   ,@p_user
		   ,''W''
		   ,@p_MAP_RECORD_ID
		   ,@p_MAP_PRODUCTION_LINE);     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_w = (@w_audit_today_w - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) +''-'' + CONVERT(VARCHAR,@p_MAI_DEPARTMENT_ID) +'' , '' ;
  FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID,@p_MAI_ITEM_ID,@p_MAP_NBR_VEHICLES, @p_MAI_DEPARTMENT_ID,@p_MAP_RECORD_ID,@p_MAP_PRODUCTION_LINE
        END 
CLOSE	cr
DEALLOCATE cr 


        set @w_errors = @w_errors +
		        ''<SessionProperty name=''''S_Message''''><Value>Audit# '' + CONVERT(VARCHAR,@p_audit_id) + '' Created. Item/Dept: ''
				 + @p_list  +
                '' added to Audit</Value></SessionProperty>''	;
END

		set @p_errors = ''<Response><SetSessionProperty>'' + @w_errors + ''</SetSessionProperty></Response>''; 
		
		
		
END



' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_mai_select_audit_items2]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_mai_select_audit_items2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Francisco Daffre Catavolt, Inc >
-- Create date: <August 30thMay 23, 2016>
-- Description:	<Select Items for Daily audit>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_mai_select_audit_items2] 
	@p_user nvarchar(10), 
	@p_audit_date date,
	@p_audit_id int,
	@p_errors nvarchar(2048) output
AS
BEGIN
--	SET @p_errors = ''test''
	DECLARE @w_audit_today_w int = 0,
	        @w_audit_today_m int = 0,
	        @p_list nvarchar(200) = '''',
	        @w_errors nvarchar(2000) = '''', 
			@p_MAI_AUDIT_ID int, 
            @p_MAI_ITEM_ID int,
            @p_MAI_DEPARTMENT_ID int;
IF (SELECT COUNT(*) FROM [dbo].[inspect_audit_items] WHERE MAI_AUDIT_ID = @p_audit_id) > 0 
BEGIN 
 SET @w_errors = @w_errors +
     ''<SessionProperty name=''''S_Message''''><Value>Items were already added to Audit#'' + CONVERT(VARCHAR,@p_audit_id) + '' Please select another Audit</Value></SessionProperty>''	; 
 END 
ELSE
 BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_NEWID = NEWID();
	declare @w_countALL_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'')
	declare @w_countALL_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'')
	declare @w_countAUDIT_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))
	declare @w_countAUDIT_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))

-- DAILY ITEMS
INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID]
		   ,[MAI_MAP_AUDIT_FREQ_CODE])
		   SELECT       
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID], ''D''
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''D'' 
   ORDER BY MAP_AUDIT_NEWID;



 -- MONTHLY PROCESS	
	IF @w_countALL_M > 0 AND @w_countAUDIT_M = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''M'' 
			SET @w_audit_today_m = ROUND((@w_countALL_M/20)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_m = ROUND((@w_countALL_M/20)+0.5,0);
	

	DECLARE crM CURSOR READ_ONLY FOR 
   SELECT 
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID]
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID;
OPEN crM
FETCH NEXT FROM crM INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID
WHILE @@FETCH_STATUS= 0 AND @w_audit_today_m >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID], [MAI_MAP_AUDIT_FREQ_CODE])
			VALUES (@p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID,''M'');     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_m = (@w_audit_today_m - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) ;
  FETCH NEXT FROM crM INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID 
        END 
CLOSE	crM
DEALLOCATE crM 

	
-- WEEKLY PROCESS	
	IF @w_countALL_W > 0 AND @w_countAUDIT_W = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''W'' 
			SET @w_audit_today_w = ROUND((@w_countALL_W/5)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_w = ROUND((@w_countALL_W/5)+0.5,0);
	

DECLARE cr CURSOR READ_ONLY FOR 
   SELECT 
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID]
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID
OPEN cr
FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID
WHILE @@FETCH_STATUS= 0 AND @w_audit_today_w >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID], [MAI_MAP_AUDIT_FREQ_CODE])
			VALUES (@p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID,''W'');     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_w = (@w_audit_today_w - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) +''-'' + CONVERT(VARCHAR,@p_MAI_DEPARTMENT_ID) +'' '' ;
  FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID 
        END 
CLOSE	cr
DEALLOCATE cr 


        set @w_errors = @w_errors +
		        ''<SessionProperty name=''''S_Message''''><Value>'' + @p_list  +
                ''items added to weekely process</Value></SessionProperty>''	;
END

		set @p_errors = ''<Response><SetSessionProperty>'' + @w_errors + ''</SetSessionProperty></Response>''; 
		
		
		
END



' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_mai_select_audit_itemsWEEK]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_mai_select_audit_itemsWEEK]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Author, Francisco Daffre Catavolt, Inc >
-- Create date: <Create Date, August 30thMay 23, 2016>
-- Description:	<Select Items for Daily audit>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_mai_select_audit_itemsWEEK] 
	@p_user nvarchar(10), 
	@p_audit_date date,
	@p_audit_id int,
	@p_errors nvarchar(2048) output
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_NEWID = NEWID();
	declare @w_countALL_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'')
	declare @w_countALL_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'')
	declare @w_countAUDIT_W int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))
	declare @w_countAUDIT_M int = 
	(SELECT COUNT(*) FROM [dbo].[inspect_audit_plan]
         WHERE MAP_AUDIT_FREQ_CODE = ''M'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0))
	DECLARE @w_audit_today_w int = 0,
	        @w_audit_today_m int = 0,
	        @p_list nvarchar(200) = '''',
	        @w_errors nvarchar(2000) = '''' 
	
-- WEEKLY PROCESS	
	IF @w_countALL_W > 0 AND @w_countAUDIT_W = 0 
		BEGIN 
			UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 0 WHERE MAP_AUDIT_FREQ_CODE = ''W'' 
			SET @w_audit_today_w = ROUND((@w_countALL_W/5)+0.5,0)
		END
	  ELSE  
		SET @w_audit_today_w = ROUND((@w_countALL_W/5)+0.5,0)
	END;
DECLARE @p_MAI_AUDIT_ID int 
           ,@p_MAI_ITEM_ID int
           ,@p_MAI_DEPARTMENT_ID int;
DECLARE cr CURSOR READ_ONLY FOR 
   SELECT --TOP @w_audit_today_w       
   @p_audit_id
   ,[MAP_ITEM_ID]
   ,[MAP_DEPARTMENT_ID]
    FROM [dbo].[inspect_audit_plan]
	WHERE MAP_AUDIT_FREQ_CODE = ''W'' AND
         (MAP_AUDIT_SELECTED IS NULL OR MAP_AUDIT_SELECTED = 0)
   ORDER BY MAP_AUDIT_NEWID
OPEN cr
FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID
WHILE @@FETCH_STATUS=0 AND @w_audit_today_w >= 1 BEGIN
		INSERT INTO [dbo].[inspect_audit_items]
           ([MAI_AUDIT_ID]
           ,[MAI_ITEM_ID]
           ,[MAI_DEPARTMENT_ID], [MAI_MAP_AUDIT_FREQ_CODE])
			VALUES (@p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID,''W'');     
   UPDATE [dbo].[inspect_audit_plan] SET MAP_AUDIT_SELECTED = 1 
			WHERE MAP_ITEM_ID = @p_MAI_ITEM_ID AND [MAP_DEPARTMENT_ID] = @p_MAI_DEPARTMENT_ID;
   SET @w_audit_today_w = (@w_audit_today_w - 1)
   SET @p_list = @p_list + CONVERT(VARCHAR,@p_MAI_ITEM_ID) ;
  FETCH NEXT FROM cr INTO @p_MAI_AUDIT_ID, @p_MAI_ITEM_ID, @p_MAI_DEPARTMENT_ID 
        END 
CLOSE	cr
DEALLOCATE cr

        set @w_errors = @w_errors +
		        ''<SessionProperty name=''''S_Message''''><Value>'' + @p_list  +
                ''items added to weekely process</Value></SessionProperty>''	;
		set @p_errors = ''<Response><SetSessionProperty>'' + @w_errors + ''</SetSessionProperty></Response>'';



' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_count_auditnc]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_count_auditnc]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_count_auditnc] 

	-- Add the parameters for the stored procedure here>

	@P_SALES_ORDER varchar (7),
--	@P_INSPECTIONS_FOUND varchar (1) OUT,
	@P_RESPONSE varchar (2048) OUT

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
	-- T. Eliasen 6/29/16: Count the number of audit vehicles records for this Sales Order that are non-conforming
	--                     Pass the count back to Extender Action
	--                     In Extender, do not allow the user to create Final Inspection Headers (button) if the count > 0
	declare @P_AUDITNC_FOUND varchar (1)
	IF Exists (Select * from inspect_audit_item_vehicles where MAIV_ORDER_NO = @P_SALES_ORDER and MAIV_RESULT_CODE = ''F'')  
							SET @P_AUDITNC_FOUND = ''Y''
					ELSE	SET @P_AUDITNC_FOUND = ''N''
					END

	SET @P_RESPONSE = ''<Response>'' 
				+ 	''<SetSessionProperty>'' 
						+ ''<SessionProperty name=''''U_AUDITNC_FOUND''''>''	
							+ ''<Value>'' + @P_AUDITNC_FOUND + ''</Value>''
						+ ''</SessionProperty>''
				+	 ''</SetSessionProperty>''
				+ ''</Response>''


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_count_headers_wm2]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_count_headers_wm2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_count_headers_wm2] 

	-- Add the parameters for the stored procedure here>

	@P_SALES_ORDER varchar (7),
--	@P_INSPECTIONS_FOUND varchar (1) OUT,
	@P_RESPONSE varchar (2048) OUT

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
	-- T. Eliasen 6/29/16: Count the number of Final Inspection Header records for this Sales Order (from MAS)
	--                     Pass the count back to Extender Action
	--                     In Extender, do not allow the user to crete Final Inspection Headers (button) if the count > 0
	declare @P_INSPECTIONS_FOUND varchar (1)
	IF Exists (Select * from inspect_final_inspection_header where FIH_ORDER_NO = @P_SALES_ORDER)  
							SET @P_INSPECTIONS_FOUND = ''Y''
					ELSE	SET @P_INSPECTIONS_FOUND = ''N''
					END

	SET @P_RESPONSE = ''<Response>'' 
				+ 	''<SetSessionProperty>'' 
						+ ''<SessionProperty name=''''U_HEADERS_FOUND''''>''	
							+ ''<Value>'' + @P_INSPECTIONS_FOUND + ''</Value>''
						+ ''</SessionProperty>''
				+	 ''</SetSessionProperty>''
				+ ''</Response>''


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_count_insp_items]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_count_insp_items]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_count_insp_items] 

	-- Add the parameters for the stored procedure here>

	@P_INSPECTION_ID varchar (7),
--	@P_INSPECTIONS_FOUND varchar (1) OUT,
	@P_RESPONSE varchar (2048) OUT

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
	-- T. Eliasen 6/29/16: Count the number of final inspection item records for this inspection
	--                     Pass the count back to Extender Action
	--                     In Extender, do not allow the user to load items if the count > 0
	declare @P_count varchar (1)
	SET @P_count = (Select count(*) from inspect_final_inspection_items where FII_INSPECTION_ID = @P_INSPECTION_ID)  

	SET @P_RESPONSE = ''<Response>'' 
				+ 	''<SetSessionProperty>'' 
						+ ''<SessionProperty name=''''U_ITEM_COUNT''''>''	
							+ ''<Value>'' + @P_count + ''</Value>''
						+ ''</SessionProperty>''
				+	 ''</SetSessionProperty>''
				+ ''</Response>''

END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_delete_inspection]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_delete_inspection]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_delete_inspection] 

	-- Add the parameters for the stored procedure here>

	@P_INSPECTION_ID int,
	@P_DELETE_CODE varchar (1)
	--@P_RESULT_CODE varchar (1) OUT,
	--@P_RESULT_MESSAGE varchar (256) OUT


AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	Declare @VAR_FIH_STATUS_CODE varchar (1)
	Declare @P_RESULT_CODE varchar (1)
	Declare @P_RESULT_MESSAGE varchar (256)

    -- T. Eliasen 7/22/16: Delete Final Inspecton records ...if header is not rerleased
	--						Options for Delete Code = "H"eader, "I"tems, "A"ttributes 
	Set @VAR_FIH_STATUS_CODE = (select FIH_STATUS_CODE from inspect_final_inspection_header where FIH_INSPECTION_ID = @P_INSPECTION_ID)

	IF (@VAR_FIH_STATUS_CODE = ''R'')			
	Begin																																
			SET @P_RESULT_CODE = ''F''
			SET @P_RESULT_MESSAGE = ''Inspection is released; Cannot Delete data.''																								
	End
	ELSE																								
			SET @P_RESULT_CODE = ''P''
			
			IF (@P_DELETE_CODE = ''H'')
			Begin
				Delete from inspect_final_inspection_item_choices Where FIIC_INSPECTION_ID = @P_INSPECTION_ID
				Delete from inspect_final_inspection_items Where FII_INSPECTION_ID = @P_INSPECTION_ID
				Delete from inspect_final_inspection_header Where FIH_INSPECTION_ID = @P_INSPECTION_ID
				SET @P_RESULT_MESSAGE = ''Inspection is NOT released; Delete Code = "H"; Attributes, items, and header all deleted.''
			End
			
			IF (@P_DELETE_CODE = ''I'')
			Begin	-- delete choices (attributes) and items if @P_DELETE_CODE = "I"
				Delete from inspect_final_inspection_item_choices Where FIIC_INSPECTION_ID = @P_INSPECTION_ID
				Delete from inspect_final_inspection_items Where FII_INSPECTION_ID = @P_INSPECTION_ID
				SET @P_RESULT_MESSAGE = ''Inspection is NOT released; Delete Code = "I"; Attributes and items (Not Header) deleted.''
			END
				
			IF (@P_DELETE_CODE = ''A'')
			Begin
				-- delete choices (attributes) if @P_DELETE_CODE = "A"
				Delete from inspect_final_inspection_item_choices Where FIIC_INSPECTION_ID = @P_INSPECTION_ID
				SET @P_RESULT_MESSAGE = ''Inspection is NOT released; Delete Code = "A"; Only Attributes deleted.''
			END
	End


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_get_header_status]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_get_header_status]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_get_header_status] 

	-- Add the parameters for the stored procedure here>

	@P_INSPECTION_ID int,
--	@P_INSPECTIONS_FOUND varchar (1) OUT,
	@P_RESPONSE varchar (2048) OUT

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
	-- T. Eliasen 6/29/16: Count the number of audit vehicles records for this Sales Order that are non-conforming
	--                     Pass the count back to Extender Action
	--                     In Extender, do not allow the user to create Final Inspection Headers (button) if the count > 0
	declare @P_HEADER_STATUS varchar (1)
	SET @P_HEADER_STATUS = (Select FIH_STATUS_CODE from inspect_final_inspection_header where FIH_INSPECTION_ID = @P_INSPECTION_ID)  

	SET @P_RESPONSE = ''<Response>'' 
				+ 	''<SetSessionProperty>'' 
						+ ''<SessionProperty name=''''U_HEADER_STATUS''''>''	
							+ ''<Value>'' + @P_HEADER_STATUS + ''</Value>''
						+ ''</SessionProperty>''
				+	 ''</SetSessionProperty>''
				+ ''</Response>''

END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_toggle_attribute]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_toggle_attribute]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_toggle_attribute] 

	-- Add the parameters for the stored procedure here>

	@P_FIIC_UNIQUE_ID int,
	@P_FIIC_IC_UNIQUE_ID int,
	@P_FIIC_FII_RECORD_ID int,
	@P_FIIC_INSPECTION_ID int,
	@P_FIIC_IPI_ID int,
	@P_CREATE_USER varchar (20),
	@P_COMPANY_CODE varchar (3)

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
	-- T. Eliasen 5/23/16: query table to locate a record (Final Inspection Item Attribute)
	--                     If record found, delete it (De-select the attribute from the inspection)
	--                     If not found, add the row to the table (select the attribute) 
	
	If Exists (Select FIIC_UNIQUE_ID 
				from	inspect_final_inspection_item_choices 
				where	FIIC_INSPECTION_ID = @P_FIIC_INSPECTION_ID AND
						FIIC_FII_RECORD_ID = @P_FIIC_FII_RECORD_ID AND
						FIIC_IC_UNIQUE_ID  = @P_FIIC_IC_UNIQUE_ID
				)
	   -- delete the record from the table
	   delete from inspect_final_inspection_item_choices 
	   where	FIIC_INSPECTION_ID = @P_FIIC_INSPECTION_ID AND
				FIIC_FII_RECORD_ID = @P_FIIC_FII_RECORD_ID AND
				FIIC_IC_UNIQUE_ID  = @P_FIIC_IC_UNIQUE_ID
	Else
	   -- insert the row into the table
	   INSERT INTO
	   inspect_final_inspection_item_choices(
	   FIIC_IC_UNIQUE_ID,
	   FIIC_FII_RECORD_ID,
	   FIIC_INSPECTION_ID,
	   FIIC_IPI_ID,
	   CREATE_USER,
	   COMPANY_CODE)
	   VALUES(
	   	@P_FIIC_IC_UNIQUE_ID,
	    @P_FIIC_FII_RECORD_ID,
	    @P_FIIC_INSPECTION_ID,
	    @P_FIIC_IPI_ID,
		@P_CREATE_USER,
		@P_COMPANY_CODE)
	END


' 
END
GO
/****** Object:  StoredProcedure [dbo].[sp_inspect_proc_toggle_attribute_saved]    Script Date: 2/21/2019 5:54:22 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_inspect_proc_toggle_attribute_saved]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author, Tim Eliasen Catavolt, Inc >
-- Create date: <Create Date,May 23, 2016>
-- Description:	<Description - Project = Catavolt Extender VFI - Vehicle Final Inspection>
-- =============================================
CREATE PROCEDURE [dbo].[sp_inspect_proc_toggle_attribute_saved] 

	-- Add the parameters for the stored procedure here>

	@P_FIIC_UNIQUE_ID int,
	@P_FIIC_IC_UNIQUE_ID int,
	@P_FIIC_FII_RECORD_ID int,
	@P_FIIC_INSPECTION_ID int,
	@P_FIIC_IPI_ID int,
	@P_CREATE_USER varchar (20),
	@P_COMPANY_CODE varchar (3)

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    -- Insert statements for procedure here
	-- T. Eliasen 5/23/16: query table to locate a record (Final Inspection Item Attribute)
	--                     If record found, delete it (De-select the attribute from the inspection)
	--                     If not found, add the row to the table (select the attribute) 
	
	If Exists (Select FIIC_UNIQUE_ID from inspect_final_inspection_item_choices where FIIC_UNIQUE_ID = @P_FIIC_UNIQUE_ID)
	   -- delete the record from the table
	   delete from inspect_final_inspection_item_choices where FIIC_UNIQUE_ID = @P_FIIC_UNIQUE_ID
	Else
	   -- insert the row into the table
	   INSERT INTO
	   inspect_final_inspection_item_choices(
	   FIIC_IC_UNIQUE_ID,
	   FIIC_FII_RECORD_ID,
	   FIIC_INSPECTION_ID,
	   FIIC_IPI_ID,
	   CREATE_USER,
	   COMPANY_CODE)
	   VALUES(
	   	@P_FIIC_IC_UNIQUE_ID,
	    @P_FIIC_FII_RECORD_ID,
	    @P_FIIC_INSPECTION_ID,
	    @P_FIIC_IPI_ID,
		@P_CREATE_USER,
		@P_COMPANY_CODE)
	END


' 
END
GO
